/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.google.common.collect;

import com.dfsek.terra.lib.google.common.annotations.GwtCompatible;
import com.dfsek.terra.lib.google.common.annotations.VisibleForTesting;
import com.dfsek.terra.lib.google.common.collect.ImmutableBiMap;
import com.dfsek.terra.lib.google.common.collect.ImmutableList;
import com.dfsek.terra.lib.google.common.collect.ImmutableMapEntry;
import com.dfsek.terra.lib.google.common.collect.ImmutableMapEntrySet;
import com.dfsek.terra.lib.google.common.collect.ImmutableMapKeySet;
import com.dfsek.terra.lib.google.common.collect.ImmutableSet;
import com.dfsek.terra.lib.google.common.collect.Maps;
import com.dfsek.terra.lib.google.common.collect.RegularImmutableMap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class JdkBackedImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    private final transient ImmutableList<Map.Entry<K, V>> entries;
    private final Map<K, V> forwardDelegate;
    private final Map<V, K> backwardDelegate;
    @LazyInit
    @RetainedWith
    private transient JdkBackedImmutableBiMap<V, K> inverse;

    @VisibleForTesting
    static <K, V> ImmutableBiMap<K, V> create(int n, Map.Entry<K, V>[] entryArray) {
        HashMap forwardDelegate = Maps.newHashMapWithExpectedSize(n);
        HashMap backwardDelegate = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry<K, V> e2 = RegularImmutableMap.makeImmutable(entryArray[i]);
            entryArray[i] = e2;
            Object oldValue = forwardDelegate.putIfAbsent(e2.getKey(), e2.getValue());
            if (oldValue != null) {
                String string = String.valueOf(e2.getKey());
                String string2 = String.valueOf(oldValue);
                throw JdkBackedImmutableBiMap.conflictException("key", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString(), entryArray[i]);
            }
            Object oldKey = backwardDelegate.putIfAbsent(e2.getValue(), e2.getKey());
            if (oldKey == null) continue;
            String string = String.valueOf(oldKey);
            String string3 = String.valueOf(e2.getValue());
            throw JdkBackedImmutableBiMap.conflictException("value", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append("=").append(string3).toString(), entryArray[i]);
        }
        ImmutableList<Map.Entry<K, V>> entryList = ImmutableList.asImmutableList(entryArray, n);
        return new JdkBackedImmutableBiMap<K, V>(entryList, forwardDelegate, backwardDelegate);
    }

    private JdkBackedImmutableBiMap(ImmutableList<Map.Entry<K, V>> entries, Map<K, V> forwardDelegate, Map<V, K> backwardDelegate) {
        this.entries = entries;
        this.forwardDelegate = forwardDelegate;
        this.backwardDelegate = backwardDelegate;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        JdkBackedImmutableBiMap<K, V> result = this.inverse;
        if (result == null) {
            this.inverse = result = new JdkBackedImmutableBiMap<K, V>(new InverseEntries(), this.backwardDelegate, this.forwardDelegate);
            result.inverse = this;
        }
        return result;
    }

    @Override
    public V get(@Nullable Object key) {
        return this.forwardDelegate.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    private final class InverseEntries
    extends ImmutableList<Map.Entry<V, K>> {
        private InverseEntries() {
        }

        @Override
        public Map.Entry<V, K> get(int index) {
            Map.Entry entry = (Map.Entry)JdkBackedImmutableBiMap.this.entries.get(index);
            return Maps.immutableEntry(entry.getValue(), entry.getKey());
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public int size() {
            return JdkBackedImmutableBiMap.this.entries.size();
        }
    }
}

