/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.lib.commons.text.lookup;

import com.dfsek.terra.lib.commons.lang3.StringUtils;
import com.dfsek.terra.lib.commons.text.lookup.AbstractStringLookup;
import com.dfsek.terra.lib.commons.text.lookup.IllegalArgumentExceptions;
import java.nio.file.Files;
import java.nio.file.Paths;

final class FileStringLookup
extends AbstractStringLookup {
    static final AbstractStringLookup INSTANCE = new FileStringLookup();

    private FileStringLookup() {
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        String[] keys = key.split(String.valueOf(':'));
        int keyLen = keys.length;
        if (keyLen < 2) {
            throw IllegalArgumentExceptions.format("Bad file key format [%s], expected format is CharsetName:DocumentPath.", key);
        }
        String charsetName = keys[0];
        String fileName = StringUtils.substringAfter(key, 58);
        try {
            return new String(Files.readAllBytes(Paths.get(fileName, new String[0])), charsetName);
        }
        catch (Exception e2) {
            throw IllegalArgumentExceptions.format(e2, "Error looking up file [%s] with charset [%s].", fileName, charsetName);
        }
    }
}

