/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.config;

import com.dfsek.tectonic.api.config.template.ConfigTemplate;
import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.tectonic.api.exception.ConfigException;
import com.dfsek.tectonic.api.loader.ConfigLoader;
import com.dfsek.tectonic.yaml.YamlConfiguration;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.config.PluginConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigImpl
implements ConfigTemplate,
PluginConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigImpl.class);
    @Value(value="debug.commands")
    @Default
    private boolean debugCommands = false;
    @Value(value="debug.profiler")
    @Default
    private boolean debugProfiler = false;
    @Value(value="debug.script")
    @Default
    private boolean debugScript = false;
    @Value(value="biome-search-resolution")
    @Default
    private int biomeSearch = 4;
    @Value(value="cache.structure")
    @Default
    private int structureCache = 32;
    @Value(value="cache.sampler")
    @Default
    private int samplerCache = 1024;
    @Value(value="cache.biome-provider")
    @Default
    private int providerCache = 32;
    @Value(value="dump-default")
    @Default
    private boolean dumpDefaultData = true;
    @Value(value="script.max-recursion")
    @Default
    private int maxRecursion = 1000;

    @Override
    public void load(Platform platform) {
        logger.info("Loading config values from config.yml");
        try (FileInputStream file = new FileInputStream(new File(platform.getDataFolder(), "config.yml"));){
            ConfigLoader loader = new ConfigLoader();
            loader.load(this, new YamlConfiguration(file, "config.yml"));
        }
        catch (ConfigException | IOException | UncheckedIOException e2) {
            logger.error("Failed to load config", (Throwable)e2);
        }
        if (this.debugCommands) {
            logger.info("Debug commands enabled.");
        }
        if (this.debugProfiler) {
            logger.info("Debug profiler enabled.");
        }
        if (this.debugScript) {
            logger.info("Script debug blocks enabled.");
        }
    }

    @Override
    public boolean dumpDefaultConfig() {
        return this.dumpDefaultData;
    }

    @Override
    public boolean isDebugCommands() {
        return this.debugCommands;
    }

    @Override
    public boolean isDebugProfiler() {
        return this.debugProfiler;
    }

    @Override
    public boolean isDebugScript() {
        return this.debugScript;
    }

    @Override
    public int getBiomeSearchResolution() {
        return this.biomeSearch;
    }

    @Override
    public int getStructureCache() {
        return this.structureCache;
    }

    @Override
    public int getSamplerCache() {
        return this.samplerCache;
    }

    @Override
    public int getMaxRecursion() {
        return this.maxRecursion;
    }

    @Override
    public int getProviderCache() {
        return this.providerCache;
    }
}

