/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit.world;

import com.dfsek.terra.api.block.BlockType;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.block.state.properties.enums.Half;
import com.dfsek.terra.api.block.state.properties.enums.RailShape;
import com.dfsek.terra.api.block.state.properties.enums.RedstoneConnection;
import com.dfsek.terra.api.entity.Entity;
import com.dfsek.terra.api.entity.Player;
import com.dfsek.terra.api.inventory.ItemStack;
import com.dfsek.terra.api.transform.Validator;
import com.dfsek.terra.api.util.vector.Vector3;
import com.dfsek.terra.api.world.ServerWorld;
import com.dfsek.terra.api.world.info.WorldProperties;
import com.dfsek.terra.bukkit.BukkitCommandSender;
import com.dfsek.terra.bukkit.BukkitEntity;
import com.dfsek.terra.bukkit.BukkitPlayer;
import com.dfsek.terra.bukkit.world.BukkitChunk;
import com.dfsek.terra.bukkit.world.BukkitServerWorld;
import com.dfsek.terra.bukkit.world.BukkitWorldProperties;
import com.dfsek.terra.bukkit.world.block.BukkitBlockTypeAndItem;
import com.dfsek.terra.bukkit.world.block.data.BukkitBlockState;
import com.dfsek.terra.bukkit.world.inventory.BukkitItemStack;
import com.dfsek.terra.bukkit.world.inventory.meta.BukkitEnchantment;
import com.dfsek.terra.transform.MapTransform;
import com.dfsek.terra.transform.TransformerImpl;
import org.bukkit.Axis;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;

public final class BukkitAdapter {
    public static TransformerImpl<TreeType, String> TREE_TRANSFORMER = new TransformerImpl.Builder<TreeType, String>().addTransform(new MapTransform<TreeType, String>().add(TreeType.COCOA_TREE, "JUNGLE_COCOA").add(TreeType.BIG_TREE, "LARGE_OAK").add(TreeType.TALL_REDWOOD, "LARGE_SPRUCE").add(TreeType.REDWOOD, "SPRUCE").add(TreeType.TREE, "OAK").add(TreeType.MEGA_REDWOOD, "MEGA_SPRUCE").add(TreeType.SWAMP, "SWAMP_OAK"), new Validator[0]).addTransform(Enum::toString, new Validator[0]).build();

    public static BlockState adapt(BlockData data) {
        return BukkitBlockState.newInstance(data);
    }

    public static BlockData adapt(BlockState data) {
        return ((BukkitBlockState)data).getHandle();
    }

    public static com.dfsek.terra.api.block.state.properties.enums.Axis adapt(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> com.dfsek.terra.api.block.state.properties.enums.Axis.X;
            case Axis.Y -> com.dfsek.terra.api.block.state.properties.enums.Axis.Y;
            case Axis.Z -> com.dfsek.terra.api.block.state.properties.enums.Axis.Z;
        };
    }

    public static WorldProperties adapt(WorldInfo worldInfo) {
        return new BukkitWorldProperties(worldInfo);
    }

    public static WorldInfo adapt(WorldProperties properties) {
        return (WorldInfo)properties.getHandle();
    }

    public static Half adapt(Bisected.Half half) {
        return switch (half) {
            default -> throw new IncompatibleClassChangeError();
            case Bisected.Half.BOTTOM -> Half.BOTTOM;
            case Bisected.Half.TOP -> Half.TOP;
        };
    }

    public static RedstoneConnection adapt(RedstoneWire.Connection connection) {
        return switch (connection) {
            default -> throw new IncompatibleClassChangeError();
            case RedstoneWire.Connection.NONE -> RedstoneConnection.NONE;
            case RedstoneWire.Connection.UP -> RedstoneConnection.UP;
            case RedstoneWire.Connection.SIDE -> RedstoneConnection.SIDE;
        };
    }

    public static RedstoneWire.Connection adapt(RedstoneConnection connection) {
        return switch (connection) {
            default -> throw new IncompatibleClassChangeError();
            case RedstoneConnection.SIDE -> RedstoneWire.Connection.SIDE;
            case RedstoneConnection.UP -> RedstoneWire.Connection.UP;
            case RedstoneConnection.NONE -> RedstoneWire.Connection.NONE;
        };
    }

    public static RailShape adapt(Rail.Shape shape) {
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case Rail.Shape.SOUTH_WEST -> RailShape.SOUTH_WEST;
            case Rail.Shape.SOUTH_EAST -> RailShape.SOUTH_EAST;
            case Rail.Shape.NORTH_EAST -> RailShape.NORTH_EAST;
            case Rail.Shape.NORTH_WEST -> RailShape.NORTH_WEST;
            case Rail.Shape.ASCENDING_EAST -> RailShape.ASCENDING_EAST;
            case Rail.Shape.ASCENDING_WEST -> RailShape.ASCENDING_WEST;
            case Rail.Shape.ASCENDING_SOUTH -> RailShape.ASCENDING_SOUTH;
            case Rail.Shape.ASCENDING_NORTH -> RailShape.ASCENDING_NORTH;
            case Rail.Shape.NORTH_SOUTH -> RailShape.NORTH_SOUTH;
            case Rail.Shape.EAST_WEST -> RailShape.EAST_WEST;
        };
    }

    public static Rail.Shape adapt(RailShape shape) {
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case RailShape.EAST_WEST -> Rail.Shape.EAST_WEST;
            case RailShape.NORTH_SOUTH -> Rail.Shape.NORTH_SOUTH;
            case RailShape.ASCENDING_NORTH -> Rail.Shape.ASCENDING_NORTH;
            case RailShape.ASCENDING_SOUTH -> Rail.Shape.ASCENDING_SOUTH;
            case RailShape.ASCENDING_WEST -> Rail.Shape.ASCENDING_WEST;
            case RailShape.ASCENDING_EAST -> Rail.Shape.ASCENDING_EAST;
            case RailShape.NORTH_WEST -> Rail.Shape.NORTH_WEST;
            case RailShape.NORTH_EAST -> Rail.Shape.NORTH_EAST;
            case RailShape.SOUTH_EAST -> Rail.Shape.SOUTH_EAST;
            case RailShape.SOUTH_WEST -> Rail.Shape.SOUTH_WEST;
        };
    }

    public static Bisected.Half adapt(Half half) {
        return switch (half) {
            case Half.TOP -> Bisected.Half.TOP;
            case Half.BOTTOM -> Bisected.Half.BOTTOM;
            default -> throw new IllegalStateException();
        };
    }

    public static Axis adapt(com.dfsek.terra.api.block.state.properties.enums.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case com.dfsek.terra.api.block.state.properties.enums.Axis.Z -> Axis.Z;
            case com.dfsek.terra.api.block.state.properties.enums.Axis.Y -> Axis.Y;
            case com.dfsek.terra.api.block.state.properties.enums.Axis.X -> Axis.X;
        };
    }

    public static Vector3 adapt(Location location) {
        return Vector3.of(location.getX(), location.getY(), location.getZ());
    }

    public static Vector adapt(Vector3 vector3) {
        return new Vector(vector3.getX(), vector3.getY(), vector3.getZ());
    }

    public static Vector3 adapt(Vector vector) {
        return Vector3.of(vector.getX(), vector.getY(), vector.getZ());
    }

    public static com.dfsek.terra.api.command.CommandSender adapt(CommandSender sender) {
        return new BukkitCommandSender(sender);
    }

    public static Entity adapt(org.bukkit.entity.Entity entity) {
        return new BukkitEntity(entity);
    }

    public static CommandSender adapt(com.dfsek.terra.api.command.CommandSender sender) {
        return ((BukkitCommandSender)sender).getHandle();
    }

    public static ServerWorld adapt(World world) {
        return new BukkitServerWorld(world);
    }

    public static World adapt(ServerWorld world) {
        return (World)world.getHandle();
    }

    public static com.dfsek.terra.api.world.chunk.Chunk adapt(Chunk chunk) {
        return new BukkitChunk(chunk);
    }

    public static Chunk adapt(com.dfsek.terra.api.world.chunk.Chunk chunk) {
        return (Chunk)chunk.getHandle();
    }

    public static com.dfsek.terra.api.inventory.item.Enchantment adapt(Enchantment enchantment) {
        return new BukkitEnchantment(enchantment);
    }

    public static Enchantment adapt(com.dfsek.terra.api.inventory.item.Enchantment enchantment) {
        return ((BukkitEnchantment)enchantment).getHandle();
    }

    public static org.bukkit.entity.Player adapt(Player player) {
        return ((BukkitPlayer)player).getHandle();
    }

    public static Player adapt(org.bukkit.entity.Player player) {
        return new BukkitPlayer(player);
    }

    public static BukkitBlockTypeAndItem adapt(Material material) {
        return new BukkitBlockTypeAndItem(material);
    }

    public static Material adapt(BlockType type) {
        return ((BukkitBlockTypeAndItem)type).getHandle();
    }

    public static ItemStack adapt(org.bukkit.inventory.ItemStack in) {
        return new BukkitItemStack(in);
    }

    public static org.bukkit.inventory.ItemStack adapt(ItemStack in) {
        return ((BukkitItemStack)in).getHandle();
    }
}

