/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit.util;

import com.dfsek.terra.lib.paperlib.PaperLib;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtil {
    public static final SpigotVersionInfo SPIGOT_VERSION_INFO;
    public static final MinecraftVersionInfo MINECRAFT_VERSION_INFO;
    private static final Logger logger;

    public static MinecraftVersionInfo getMinecraftVersionInfo() {
        return MINECRAFT_VERSION_INFO;
    }

    public static SpigotVersionInfo getSpigotVersionInfo() {
        return SPIGOT_VERSION_INFO;
    }

    static {
        MinecraftVersionInfo mcVersionInfo;
        logger = LoggerFactory.getLogger(VersionUtil.class);
        SPIGOT_VERSION_INFO = new SpigotVersionInfo();
        try {
            mcVersionInfo = new MinecraftVersionInfo();
        }
        catch (Throwable t) {
            logger.error("Error while parsing minecraft version info. Continuing launch, but setting all versions to -1.");
            mcVersionInfo = new MinecraftVersionInfo(-1, -1, -1);
        }
        MINECRAFT_VERSION_INFO = mcVersionInfo;
    }

    public static final class MinecraftVersionInfo {
        private static final Logger logger = LoggerFactory.getLogger(MinecraftVersionInfo.class);
        private static final Pattern VERSION_PATTERN = Pattern.compile("v?(\\d+)_(\\d+)_R(\\d+)");
        private final int major;
        private final int minor;
        private final int patch;

        private MinecraftVersionInfo() {
            this(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3]);
        }

        private MinecraftVersionInfo(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        private MinecraftVersionInfo(String versionString) {
            Matcher versionMatcher = VERSION_PATTERN.matcher(versionString);
            if (versionMatcher.find()) {
                this.major = Integer.parseInt(versionMatcher.group(1));
                this.minor = Integer.parseInt(versionMatcher.group(2));
                this.patch = Integer.parseInt(versionMatcher.group(3));
            } else {
                logger.warn("Error while parsing minecraft version info. Continuing launch, but setting all versions to -1.");
                this.major = -1;
                this.minor = -1;
                this.patch = -1;
            }
        }

        public String toString() {
            if (this.major == -1 && this.minor == -1 && this.patch == -1) {
                return "Unknown";
            }
            return String.format("v%d.%d.%d", this.major, this.minor, this.patch);
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }
    }

    public static final class SpigotVersionInfo {
        private final boolean spigot;
        private final boolean paper;
        private final boolean mohist;

        public SpigotVersionInfo() {
            logger.debug("Parsing spigot version info...");
            this.paper = PaperLib.isPaper();
            this.spigot = PaperLib.isSpigot();
            boolean isMohist = false;
            try {
                Class.forName("com.mohistmc.MohistMC");
                isMohist = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.mohist = isMohist;
            logger.debug("Spigot version info parsed successfully.");
        }

        public boolean isPaper() {
            return this.paper;
        }

        public boolean isMohist() {
            return this.mohist;
        }

        public boolean isSpigot() {
            return this.spigot;
        }
    }
}

