/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit.nms.v1_19_R2;

import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.dfsek.terra.api.world.chunk.generation.ChunkGenerator;
import com.dfsek.terra.api.world.info.WorldProperties;
import com.dfsek.terra.bukkit.config.PreLoadCompatibilityOptions;
import com.dfsek.terra.bukkit.nms.v1_19_R2.NMSBiomeProvider;
import com.dfsek.terra.bukkit.nms.v1_19_R2.NMSWorldProperties;
import com.dfsek.terra.bukkit.nms.v1_19_R2.Reflection;
import com.dfsek.terra.bukkit.world.BukkitWorldProperties;
import com.dfsek.terra.bukkit.world.block.data.BukkitBlockState;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMSChunkGeneratorDelegate
extends net.minecraft.world.level.chunk.ChunkGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NMSChunkGeneratorDelegate.class);
    private final ChunkGenerator delegate;
    private final net.minecraft.world.level.chunk.ChunkGenerator vanilla;
    private final ConfigPack pack;
    private final long seed;

    public NMSChunkGeneratorDelegate(net.minecraft.world.level.chunk.ChunkGenerator vanilla, ConfigPack pack, NMSBiomeProvider biomeProvider, long seed) {
        super((WorldChunkManager)biomeProvider);
        this.delegate = pack.getGeneratorProvider().newInstance(pack);
        this.vanilla = vanilla;
        this.pack = pack;
        this.seed = seed;
    }

    @NotNull
    protected Codec<? extends net.minecraft.world.level.chunk.ChunkGenerator> a() {
        return net.minecraft.world.level.chunk.ChunkGenerator.a;
    }

    public void a(@NotNull RegionLimitedWorldAccess chunkRegion, long seed, @NotNull RandomState noiseConfig, @NotNull BiomeManager world, @NotNull StructureManager structureAccessor, @NotNull IChunkAccess chunk, @NotNull WorldGenStage.Features carverStep) {
    }

    public void a(@NotNull RegionLimitedWorldAccess region, @NotNull StructureManager structures, @NotNull RandomState noiseConfig, @NotNull IChunkAccess chunk) {
    }

    public void a(@NotNull GeneratorAccessSeed world, @NotNull IChunkAccess chunk, @NotNull StructureManager structureAccessor) {
        this.vanilla.a(world, chunk, structureAccessor);
    }

    public void a(@NotNull RegionLimitedWorldAccess region) {
        this.vanilla.a(region);
    }

    public int d() {
        return this.vanilla.d();
    }

    @NotNull
    public CompletableFuture<IChunkAccess> a(@NotNull Executor executor, @NotNull Blender blender, @NotNull RandomState noiseConfig, @NotNull StructureManager structureAccessor, @NotNull IChunkAccess chunk) {
        return this.vanilla.a(executor, blender, noiseConfig, structureAccessor, chunk).thenApply(c2 -> {
            GeneratorAccess level = Reflection.STRUCTURE_MANAGER.getLevel(structureAccessor);
            BiomeProvider biomeProvider = this.pack.getBiomeProvider();
            PreLoadCompatibilityOptions compatibilityOptions = this.pack.getContext().get(PreLoadCompatibilityOptions.class);
            if (compatibilityOptions.isBeard()) {
                this.beard(structureAccessor, chunk, new BukkitWorldProperties((WorldInfo)level.getMinecraftWorld().getWorld()), biomeProvider, compatibilityOptions);
            }
            return c2;
        });
    }

    private void beard(StructureManager structureAccessor, IChunkAccess chunk, WorldProperties world, BiomeProvider biomeProvider, PreLoadCompatibilityOptions compatibilityOptions) {
        Beardifier structureWeightSampler = Beardifier.a((StructureManager)structureAccessor, (ChunkCoordIntPair)chunk.f());
        double threshold = compatibilityOptions.getBeardThreshold();
        double airThreshold = compatibilityOptions.getAirThreshold();
        int xi = chunk.f().e << 4;
        int zi = chunk.f().f << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int depth = 0;
                for (int y = world.getMaxHeight(); y >= world.getMinHeight(); --y) {
                    double noise = structureWeightSampler.a((DensityFunction.b)new DensityFunction.e(x + xi, y, z + zi));
                    if (noise > threshold) {
                        chunk.a(new BlockPosition(x, y, z), ((CraftBlockData)((BukkitBlockState)this.delegate.getPalette(x + xi, y, z + zi, world, biomeProvider).get(depth, x + xi, y, z + zi, world.getSeed())).getHandle()).getState(), false);
                        ++depth;
                        continue;
                    }
                    if (noise < airThreshold) {
                        chunk.a(new BlockPosition(x, y, z), Blocks.a.n(), false);
                        continue;
                    }
                    depth = 0;
                }
            }
        }
    }

    public int e() {
        return this.vanilla.e();
    }

    public int f() {
        return this.vanilla.f();
    }

    public int a(int x, int z, @NotNull HeightMap.Type heightmap, @NotNull LevelHeightAccessor world, @NotNull RandomState noiseConfig) {
        int y;
        NMSWorldProperties properties = new NMSWorldProperties(this.seed, world);
        BiomeProvider biomeProvider = this.pack.getBiomeProvider();
        for (y = properties.getMaxHeight(); y >= this.f() && !heightmap.e().test(((CraftBlockData)this.delegate.getBlock(properties, x, y - 1, z, biomeProvider).getHandle()).getState()); --y) {
        }
        return y;
    }

    @NotNull
    public BlockColumn a(int x, int z, @NotNull LevelHeightAccessor world, @NotNull RandomState noiseConfig) {
        return this.vanilla.a(x, z, world, noiseConfig);
    }

    public void a(@NotNull List<String> text, @NotNull RandomState noiseConfig, @NotNull BlockPosition pos) {
    }
}

