/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit.nms.v1_19_R1;

import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.util.generic.Lazy;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.dfsek.terra.api.world.info.WorldProperties;
import com.dfsek.terra.bukkit.config.PreLoadCompatibilityOptions;
import com.dfsek.terra.bukkit.nms.v1_19_R1.NMSBiomeProvider;
import com.dfsek.terra.bukkit.nms.v1_19_R1.NMSWorldProperties;
import com.dfsek.terra.bukkit.nms.v1_19_R1.Reflection;
import com.dfsek.terra.bukkit.nms.v1_19_R1.Registries;
import com.dfsek.terra.bukkit.world.BukkitWorldProperties;
import com.dfsek.terra.bukkit.world.block.data.BukkitBlockState;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.bukkit.craftbukkit.v1_19_R1.block.data.CraftBlockData;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMSChunkGeneratorDelegate
extends ChunkGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NMSChunkGeneratorDelegate.class);
    private final com.dfsek.terra.api.world.chunk.generation.ChunkGenerator delegate;
    private final ChunkGenerator vanilla;
    private final ConfigPack pack;
    private final long seed;
    private final Map<ConcentricRingsStructurePlacement, Lazy<List<ChunkCoordIntPair>>> ringPositions = new Object2ObjectArrayMap();
    private volatile boolean rings = false;

    public NMSChunkGeneratorDelegate(ChunkGenerator vanilla, ConfigPack pack, NMSBiomeProvider biomeProvider, long seed) {
        super(Registries.structureSet(), Optional.empty(), (WorldChunkManager)biomeProvider);
        this.delegate = pack.getGeneratorProvider().newInstance(pack);
        this.vanilla = vanilla;
        this.pack = pack;
        this.seed = seed;
    }

    @NotNull
    protected Codec<? extends ChunkGenerator> b() {
        return ChunkGenerator.a;
    }

    public void a(@NotNull RegionLimitedWorldAccess chunkRegion, long seed, @NotNull RandomState noiseConfig, @NotNull BiomeManager world, @NotNull StructureManager structureAccessor, @NotNull IChunkAccess chunk, @NotNull WorldGenStage.Features carverStep) {
    }

    public void a(@NotNull RegionLimitedWorldAccess region, @NotNull StructureManager structures, @NotNull RandomState noiseConfig, @NotNull IChunkAccess chunk) {
    }

    public void a(@NotNull GeneratorAccessSeed world, @NotNull IChunkAccess chunk, @NotNull StructureManager structureAccessor) {
        this.vanilla.a(world, chunk, structureAccessor);
    }

    public void a(@NotNull RegionLimitedWorldAccess region) {
        this.vanilla.a(region);
    }

    public int e() {
        return this.vanilla.e();
    }

    @NotNull
    public CompletableFuture<IChunkAccess> a(@NotNull Executor executor, @NotNull Blender blender, @NotNull RandomState noiseConfig, @NotNull StructureManager structureAccessor, @NotNull IChunkAccess chunk) {
        return this.vanilla.a(executor, blender, noiseConfig, structureAccessor, chunk).thenApply(c -> {
            GeneratorAccess level = Reflection.STRUCTURE_MANAGER.getLevel(structureAccessor);
            BiomeProvider biomeProvider = this.pack.getBiomeProvider();
            PreLoadCompatibilityOptions compatibilityOptions = this.pack.getContext().get(PreLoadCompatibilityOptions.class);
            if (compatibilityOptions.isBeard()) {
                this.beard(structureAccessor, chunk, new BukkitWorldProperties((WorldInfo)level.getMinecraftWorld().getWorld()), biomeProvider, compatibilityOptions);
            }
            return c;
        });
    }

    private void beard(StructureManager structureAccessor, IChunkAccess chunk, WorldProperties world, BiomeProvider biomeProvider, PreLoadCompatibilityOptions compatibilityOptions) {
        Beardifier structureWeightSampler = Beardifier.a((StructureManager)structureAccessor, (ChunkCoordIntPair)chunk.f());
        double threshold = compatibilityOptions.getBeardThreshold();
        double airThreshold = compatibilityOptions.getAirThreshold();
        int xi = chunk.f().e << 4;
        int zi = chunk.f().f << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int depth = 0;
                for (int y = world.getMaxHeight(); y >= world.getMinHeight(); --y) {
                    double noise = structureWeightSampler.a((DensityFunction.b)new DensityFunction.e(x + xi, y, z + zi));
                    if (noise > threshold) {
                        chunk.a(new BlockPosition(x, y, z), ((CraftBlockData)((BukkitBlockState)this.delegate.getPalette(x + xi, y, z + zi, world, biomeProvider).get(depth, x + xi, y, z + zi, world.getSeed())).getHandle()).getState(), false);
                        ++depth;
                        continue;
                    }
                    if (noise < airThreshold) {
                        chunk.a(new BlockPosition(x, y, z), Blocks.a.m(), false);
                        continue;
                    }
                    depth = 0;
                }
            }
        }
    }

    public int f() {
        return this.vanilla.f();
    }

    public int g() {
        return this.vanilla.g();
    }

    public int a(int x, int z, @NotNull HeightMap.Type heightmap, @NotNull LevelHeightAccessor world, @NotNull RandomState noiseConfig) {
        int y;
        NMSWorldProperties properties = new NMSWorldProperties(this.seed, world);
        BiomeProvider biomeProvider = this.pack.getBiomeProvider();
        for (y = properties.getMaxHeight(); y >= this.g() && !heightmap.e().test(((CraftBlockData)this.delegate.getBlock(properties, x, y - 1, z, biomeProvider).getHandle()).getState()); --y) {
        }
        return y;
    }

    @NotNull
    public BlockColumn a(int x, int z, @NotNull LevelHeightAccessor world, @NotNull RandomState noiseConfig) {
        return this.vanilla.a(x, z, world, noiseConfig);
    }

    public void a(@NotNull List<String> text, @NotNull RandomState noiseConfig, @NotNull BlockPosition pos) {
    }

    public void a(@NotNull RandomState noiseConfig) {
        if (!this.rings) {
            super.a(noiseConfig);
            this.populateStrongholdData(noiseConfig);
            this.rings = true;
        }
    }

    public List<ChunkCoordIntPair> a(@NotNull ConcentricRingsStructurePlacement structurePlacement, @NotNull RandomState noiseConfig) {
        this.a(noiseConfig);
        return this.ringPositions.get(structurePlacement).value();
    }

    private void populateStrongholdData(RandomState noiseConfig) {
        LOGGER.info("Generating safe stronghold data. This may take up to a minute.");
        Set set = this.c.b();
        this.a().map(Holder::a).forEach(holder -> {
            StructurePlacement patt10509$temp;
            boolean match = false;
            for (StructureSet.a structureset_a : holder.a()) {
                Structure structure = (Structure)structureset_a.a().a();
                Stream stream = structure.a().a();
                if (!stream.anyMatch(set::contains)) continue;
                match = true;
            }
            if (match && (patt10509$temp = holder.b()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)patt10509$temp;
                this.ringPositions.put(concentricringsstructureplacement, Lazy.lazy(() -> this.generateRingPositions((StructureSet)holder, noiseConfig, concentricringsstructureplacement)));
            }
        });
    }

    private List<ChunkCoordIntPair> generateRingPositions(StructureSet holder, RandomState randomstate, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        if (concentricringsstructureplacement.c() == 0) {
            return List.of();
        }
        ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>();
        int i = concentricringsstructureplacement.a();
        int j = concentricringsstructureplacement.c();
        int k = concentricringsstructureplacement.b();
        HolderSet holderset = concentricringsstructureplacement.d();
        RandomSource randomsource = RandomSource.a();
        if (this.conf.strongholdSeed != null && this.b.c((Object)holder).orElse(null) == BuiltinStructureSets.r) {
            randomsource.b(this.conf.strongholdSeed.longValue());
        } else {
            randomsource.b(randomstate.a());
        }
        double d0 = randomsource.j() * Math.PI * 2.0;
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < j; ++j1) {
            double d1 = (double)(4 * i + i * i1 * 6) + (randomsource.j() - 0.5) * (double)i * 2.5;
            int k1 = (int)Math.round(Math.cos(d0) * d1);
            int l1 = (int)Math.round(Math.sin(d0) * d1);
            int i2 = SectionPosition.a((int)k1, (int)8);
            int j2 = SectionPosition.a((int)l1, (int)8);
            Objects.requireNonNull(holderset);
            Pair pair = this.c.a(i2, 0, j2, 112, arg_0 -> ((HolderSet)holderset).a(arg_0), randomsource, randomstate.c());
            if (pair != null) {
                BlockPosition blockposition = (BlockPosition)pair.getFirst();
                k1 = SectionPosition.a((int)blockposition.u());
                l1 = SectionPosition.a((int)blockposition.w());
            }
            list.add(new ChunkCoordIntPair(k1, l1));
            d0 += Math.PI * 2 / (double)k;
            if (++l != k) continue;
            l = 0;
            k += 2 * k / (++i1 + 1);
            k = Math.min(k, j - j1);
            d0 += randomsource.j() * Math.PI * 2.0;
        }
        return list;
    }
}

