/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit.nms.v1_18_R2;

import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.util.generic.Lazy;
import com.dfsek.terra.api.world.biome.generation.BiomeProvider;
import com.dfsek.terra.bukkit.nms.v1_18_R2.NMSBiomeProvider;
import com.dfsek.terra.bukkit.nms.v1_18_R2.NMSWorldProperties;
import com.dfsek.terra.bukkit.nms.v1_18_R2.Registries;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMSChunkGeneratorDelegate
extends ChunkGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NMSChunkGeneratorDelegate.class);
    private static final Lazy<List<ChunkCoordIntPair>> EMPTY = Lazy.lazy(List::of);
    private final NMSBiomeProvider biomeSource;
    private final com.dfsek.terra.api.world.chunk.generation.ChunkGenerator delegate;
    private final ChunkGenerator vanilla;
    private final ConfigPack pack;
    private final long seed;
    private final Map<ConcentricRingsStructurePlacement, Lazy<List<ChunkCoordIntPair>>> ringPositions = new Object2ObjectArrayMap();
    private volatile boolean rings = false;

    public NMSChunkGeneratorDelegate(ChunkGenerator vanilla, ConfigPack pack, NMSBiomeProvider biomeProvider, long seed) {
        super(Registries.structureSet(), Optional.empty(), (WorldChunkManager)biomeProvider, (WorldChunkManager)biomeProvider, seed);
        this.delegate = pack.getGeneratorProvider().newInstance(pack);
        this.vanilla = vanilla;
        this.biomeSource = biomeProvider;
        this.pack = pack;
        this.seed = seed;
    }

    public void a(@NotNull RegionLimitedWorldAccess chunkRegion, long seed, @NotNull BiomeManager biomeAccess, @NotNull StructureManager structureAccessor, @NotNull IChunkAccess chunk, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull WorldGenStage.Features generationStep) {
    }

    public void a(@NotNull GeneratorAccessSeed world, @NotNull IChunkAccess chunk, @NotNull StructureManager structureAccessor) {
        this.vanilla.a(world, chunk, structureAccessor);
    }

    public int g() {
        return this.vanilla.g();
    }

    @NotNull
    public CompletableFuture<IChunkAccess> a(@NotNull Executor executor, @NotNull Blender blender, @NotNull StructureManager structureAccessor, @NotNull IChunkAccess chunk) {
        return this.vanilla.a(executor, blender, structureAccessor, chunk);
    }

    public void a(@NotNull RegionLimitedWorldAccess region, @NotNull StructureManager structures, @NotNull IChunkAccess chunk) {
    }

    @NotNull
    protected Codec<? extends ChunkGenerator> b() {
        return ChunkGenerator.a;
    }

    @NotNull
    public BlockColumn a(int x, int z, LevelHeightAccessor height) {
        return this.vanilla.a(x, z, height);
    }

    @NotNull
    public ChunkGenerator a(long seed) {
        return new NMSChunkGeneratorDelegate(this.vanilla, this.pack, this.biomeSource, seed);
    }

    public void a(@NotNull RegionLimitedWorldAccess regionlimitedworldaccess) {
        this.vanilla.a(regionlimitedworldaccess);
    }

    public int f() {
        return this.vanilla.f();
    }

    @NotNull
    public Climate.Sampler d() {
        return Climate.a();
    }

    public int h() {
        return this.vanilla.h();
    }

    public int a(int x, int z, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HeightMap.Type heightmap, @NotNull LevelHeightAccessor world) {
        int y;
        NMSWorldProperties properties = new NMSWorldProperties(this.seed, world);
        BiomeProvider biomeProvider = this.pack.getBiomeProvider();
        for (y = properties.getMaxHeight(); y >= this.h() && !heightmap.e().test(((CraftBlockData)this.delegate.getBlock(properties, x, y - 1, z, biomeProvider).getHandle()).getState()); --y) {
        }
        return y;
    }

    @Nullable
    public List<ChunkCoordIntPair> a(@NotNull ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        this.i();
        return this.ringPositions.getOrDefault(concentricringsstructureplacement, EMPTY).value();
    }

    public synchronized void i() {
        if (!this.rings) {
            super.i();
            this.populateStrongholdData();
            this.rings = true;
        }
    }

    private void populateStrongholdData() {
        LOGGER.info("Generating safe stronghold data. This may take up to a minute.");
        Set set = this.d.b();
        this.a().map(Holder::a).forEach(holder -> {
            StructurePlacement structureplacement = holder.b();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                if (holder.a().stream().anyMatch(structureset_a1 -> structureset_a1.a(set::contains))) {
                    this.ringPositions.put(concentricringsstructureplacement, Lazy.lazy(() -> this.generateRingPositions((StructureSet)holder, concentricringsstructureplacement)));
                }
            }
        });
    }

    private List<ChunkCoordIntPair> generateRingPositions(StructureSet holder, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        if (concentricringsstructureplacement.d() == 0) {
            return List.of();
        }
        ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>();
        Set set = holder.a().stream().flatMap(structureset_a -> ((StructureFeature)structureset_a.a().a()).a().a()).collect(Collectors.toSet());
        int i = concentricringsstructureplacement.b();
        int j = concentricringsstructureplacement.d();
        int k = concentricringsstructureplacement.c();
        Random random = new Random();
        if (this.conf.strongholdSeed != null && this.b.c((Object)holder).orElse(null) == BuiltinStructureSets.q) {
            random.setSeed(this.conf.strongholdSeed);
        } else {
            random.setSeed(this.j);
        }
        double d0 = random.nextDouble() * Math.PI * 2.0;
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < j; ++j1) {
            double d1 = (double)(4 * i + i * i1 * 6) + (random.nextDouble() - 0.5) * (double)i * 2.5;
            int k1 = (int)Math.round(Math.cos(d0) * d1);
            int l1 = (int)Math.round(Math.sin(d0) * d1);
            int i2 = SectionPosition.a((int)k1, (int)8);
            int j2 = SectionPosition.a((int)l1, (int)8);
            Objects.requireNonNull(set);
            Pair pair = this.biomeSource.a(i2, 0, j2, 112, set::contains, random, this.d());
            if (pair != null) {
                BlockPosition blockposition = (BlockPosition)pair.getFirst();
                k1 = SectionPosition.a((int)blockposition.u());
                l1 = SectionPosition.a((int)blockposition.w());
            }
            list.add(new ChunkCoordIntPair(k1, l1));
            d0 += Math.PI * 2 / (double)k;
            if (++l != k) continue;
            l = 0;
            k += 2 * k / (++i1 + 1);
            k = Math.min(k, j - j1);
            d0 += random.nextDouble() * Math.PI * 2.0;
        }
        return list;
    }

    public void a(@NotNull List<String> arg0, @NotNull BlockPosition arg1) {
    }
}

