/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit.nms;

import com.dfsek.terra.bukkit.PlatformImpl;
import org.bukkit.Bukkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Initializer {
    public static final String NMS = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    public static final String TERRA_PACKAGE = Initializer.class.getPackageName();

    public static void init(PlatformImpl platform) {
        Logger logger = LoggerFactory.getLogger(Initializer.class);
        try {
            Class<?> initializerClass = Class.forName(TERRA_PACKAGE + "." + NMS + ".NMSInitializer");
            try {
                Initializer initializer = (Initializer)initializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                initializer.initialize(platform);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Error initializing NMS bindings. Report this to Terra.", e);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("NMS bindings for version {} do not exist. Support for this version is limited.", (Object)NMS);
            logger.error("This is usually due to running Terra on an unsupported Minecraft version.");
            logger.error("");
            logger.error("");
            for (int i = 0; i < 20; ++i) {
                logger.error("PROCEEDING WITH AN EXISTING TERRA WORLD WILL RESULT IN CORRUPTION!!!");
            }
            logger.error("");
            logger.error("");
            logger.error("NMS bindings for version {} do not exist. Support for this version is limited.", (Object)NMS);
            logger.error("This is usually due to running Terra on an unsupported Minecraft version.");
        }
    }

    public void initialize(PlatformImpl var1);
}

