/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.bukkit;

import com.dfsek.tectonic.api.TypeRegistry;
import com.dfsek.tectonic.api.depth.DepthTracker;
import com.dfsek.tectonic.api.exception.LoadException;
import com.dfsek.terra.AbstractPlatform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.config.ConfigPack;
import com.dfsek.terra.api.handle.ItemHandle;
import com.dfsek.terra.api.handle.WorldHandle;
import com.dfsek.terra.api.world.biome.PlatformBiome;
import com.dfsek.terra.bukkit.BukkitAddon;
import com.dfsek.terra.bukkit.TerraBukkitPlugin;
import com.dfsek.terra.bukkit.generator.BukkitChunkGeneratorWrapper;
import com.dfsek.terra.bukkit.handles.BukkitItemHandle;
import com.dfsek.terra.bukkit.handles.BukkitWorldHandle;
import com.dfsek.terra.bukkit.world.BukkitPlatformBiome;
import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.block.Biome;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformImpl
extends AbstractPlatform {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformImpl.class);
    private final ItemHandle itemHandle = new BukkitItemHandle();
    private final WorldHandle handle = new BukkitWorldHandle();
    private final TerraBukkitPlugin plugin;

    public PlatformImpl(TerraBukkitPlugin plugin) {
        this.plugin = plugin;
        this.load();
    }

    public TerraBukkitPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean reload() {
        this.getTerraConfig().load(this);
        this.getRawConfigRegistry().clear();
        boolean succeed = this.getRawConfigRegistry().loadAll(this);
        Bukkit.getWorlds().forEach(world -> {
            ChunkGenerator patt2402$temp = world.getGenerator();
            if (patt2402$temp instanceof BukkitChunkGeneratorWrapper) {
                BukkitChunkGeneratorWrapper wrapper = (BukkitChunkGeneratorWrapper)patt2402$temp;
                this.getConfigRegistry().get(wrapper.getPack().getRegistryKey()).ifPresent(pack -> {
                    wrapper.setPack((ConfigPack)pack);
                    LOGGER.info("Replaced pack in chunk generator for world {}", world);
                });
            }
        });
        return succeed;
    }

    @Override
    @NotNull
    public String platformName() {
        return "Bukkit";
    }

    @Override
    public void runPossiblyUnsafeTask(@NotNull Runnable task) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
    }

    @Override
    protected Iterable<BaseAddon> platformAddon() {
        return List.of(new BukkitAddon(this));
    }

    @Override
    @NotNull
    public WorldHandle getWorldHandle() {
        return this.handle;
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    @NotNull
    public ItemHandle getItemHandle() {
        return this.itemHandle;
    }

    @Override
    public void register(TypeRegistry registry) {
        super.register(registry);
        registry.registerLoader((Type)((Object)BlockState.class), (type, o, loader, depthTracker) -> this.handle.createBlockState((String)o)).registerLoader((Type)((Object)PlatformBiome.class), (type, o, loader, depthTracker) -> this.parseBiome((String)o, depthTracker)).registerLoader((Type)((Object)EntityType.class), (type, o, loader, depthTracker) -> EntityType.valueOf((String)((String)o)));
    }

    private BukkitPlatformBiome parseBiome(String id, DepthTracker depthTracker) throws LoadException {
        if (!id.startsWith("minecraft:")) {
            throw new LoadException("Invalid biome identifier " + id, depthTracker);
        }
        return new BukkitPlatformBiome(Biome.valueOf((String)id.toUpperCase(Locale.ROOT).substring(10)));
    }
}

