/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.vector;

import com.dfsek.terra.api.util.Rotation;
import com.dfsek.terra.api.util.vector.Vector3Int;

public class Vector2Int {
    private static final Vector2Int ZERO = new Vector2Int(0, 0);
    private static final Vector2Int UNIT = new Vector2Int(0, 1);
    protected int x;
    protected int z;

    protected Vector2Int(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public static Vector2Int zero() {
        return ZERO;
    }

    public static Vector2Int unit() {
        return UNIT;
    }

    public static Vector2Int of(int x, int z) {
        return new Vector2Int(x, z);
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public Vector3Int toVector3(int y) {
        return new Vector3Int(this.x, y, this.z);
    }

    public Mutable mutable() {
        return new Mutable(this.x, this.z);
    }

    public Vector2Int rotate(Rotation rotation) {
        return switch (rotation) {
            case Rotation.CW_90 -> Vector2Int.of(this.z, -this.x);
            case Rotation.CCW_90 -> Vector2Int.of(-this.z, this.x);
            case Rotation.CW_180 -> Vector2Int.of(-this.x, -this.z);
            default -> this;
        };
    }

    public int hashCode() {
        return 31 * this.x + this.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector2Int) {
            Vector2Int that = (Vector2Int)obj;
            return this.x == that.x && this.z == that.z;
        }
        return false;
    }

    public static class Mutable
    extends Vector2Int {
        protected Mutable(int x, int z) {
            super(x, z);
        }

        @Override
        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }

        @Override
        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public Vector2Int immutable() {
            return new Vector2Int(this.x, this.z);
        }
    }
}

