/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util.vector;

import com.dfsek.terra.api.util.MathUtil;
import com.dfsek.terra.api.util.vector.Vector3;
import net.jafama.FastMath;

public class Vector2 {
    protected double x;
    protected double z;

    private Vector2(double x, double z) {
        this.x = x;
        this.z = z;
    }

    public static Vector2 of(double x, double z) {
        return new Vector2(x, z);
    }

    public double length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.z * this.z;
    }

    public double distance(Vector2 other) {
        return FastMath.sqrt(this.distanceSquared(other));
    }

    public double distanceSquared(Vector2 other) {
        double dx = other.getX() - this.x;
        double dz = other.getZ() - this.z;
        return dx * dx + dz * dz;
    }

    public Vector3 extrude(double y) {
        return Vector3.of(this.x, y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockX() {
        return FastMath.floorToInt(this.x);
    }

    public int getBlockZ() {
        return FastMath.floorToInt(this.z);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + Double.hashCode(this.x);
        hash = 31 * hash + Double.hashCode(this.z);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector2)) {
            return false;
        }
        Vector2 other = (Vector2)obj;
        return MathUtil.equals(this.x, other.x) && MathUtil.equals(this.z, other.z);
    }

    public Mutable mutable() {
        return new Mutable(this.x, this.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.z + ")";
    }

    public static class Mutable
    extends Vector2 {
        private Mutable(double x, double z) {
            super(x, z);
        }

        @Override
        public double getX() {
            return this.x;
        }

        public Mutable setX(double x) {
            this.x = x;
            return this;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        public Mutable setZ(double z) {
            this.z = z;
            return this;
        }

        public Vector2 immutable() {
            return Vector2.of(this.x, this.z);
        }

        @Override
        public double length() {
            return FastMath.sqrt(this.lengthSquared());
        }

        @Override
        public double lengthSquared() {
            return this.x * this.x + this.z * this.z;
        }

        public Mutable add(double x, double z) {
            this.x += x;
            this.z += z;
            return this;
        }

        public Mutable multiply(double m) {
            this.x *= m;
            this.z *= m;
            return this;
        }

        public Mutable add(Vector2 other) {
            this.x += other.getX();
            this.z += other.getZ();
            return this;
        }

        public Mutable subtract(Vector2 other) {
            this.x -= other.getX();
            this.z -= other.getZ();
            return this;
        }

        public Mutable normalize() {
            this.divide(this.length());
            return this;
        }

        public Mutable divide(double d) {
            this.x /= d;
            this.z /= d;
            return this;
        }
    }
}

