/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.util;

import com.dfsek.terra.api.util.Range;
import java.util.Iterator;
import java.util.Random;
import net.jafama.FastMath;
import org.jetbrains.annotations.NotNull;

public class ConstantRange
implements Range {
    private int min;
    private int max;

    public ConstantRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("Minimum must not be greater than or equal to maximum!");
        }
        this.max = max;
        this.min = min;
    }

    @Override
    public Range multiply(int mult) {
        this.min *= mult;
        this.max *= mult;
        return this;
    }

    @Override
    public Range reflect(int pt) {
        return new ConstantRange(2 * pt - this.getMax(), 2 * pt - this.getMin());
    }

    @Override
    public int get(Random r) {
        return r.nextInt(this.min, this.max);
    }

    @Override
    public Range intersects(Range other) {
        try {
            return new ConstantRange(FastMath.max(this.getMin(), other.getMin()), FastMath.min(this.getMax(), other.getMax()));
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    @Override
    public Range add(int add) {
        this.min += add;
        this.max += add;
        return this;
    }

    @Override
    public Range sub(int sub) {
        this.min -= sub;
        this.max -= sub;
        return this;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new RangeIterator(this);
    }

    @Override
    public boolean isInRange(int test) {
        return test >= this.min && test < this.max;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public Range setMax(int max) {
        this.max = max;
        return this;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public Range setMin(int min) {
        this.min = min;
        return this;
    }

    @Override
    public int getRange() {
        return this.max - this.min;
    }

    public int hashCode() {
        return this.min * 31 + this.max;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantRange)) {
            return false;
        }
        Range other = (Range)obj;
        return other.getMin() == this.getMin() && other.getMax() == this.getMax();
    }

    public String toString() {
        return "Min: " + this.getMin() + ", Max:" + this.getMax();
    }

    private static class RangeIterator
    implements Iterator<Integer> {
        private final Range m;
        private Integer current;

        public RangeIterator(Range m) {
            this.m = m;
            this.current = m.getMin();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.m.getMax();
        }

        @Override
        public Integer next() {
            Integer n = this.current;
            this.current = this.current + 1;
            return this.current - 1;
        }
    }
}

