/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.api.registry;

import com.dfsek.tectonic.api.loader.type.TypeLoader;
import com.dfsek.terra.api.registry.key.RegistryKey;
import com.dfsek.terra.api.util.reflection.TypeKey;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Registry<T>
extends TypeLoader<T> {
    @Contract(pure=true)
    public Optional<T> get(@NotNull RegistryKey var1);

    @Contract(pure=true)
    public boolean contains(@NotNull RegistryKey var1);

    public void forEach(@NotNull Consumer<T> var1);

    public void forEach(@NotNull BiConsumer<RegistryKey, T> var1);

    @NotNull
    @Contract(pure=true)
    public Collection<T> entries();

    @NotNull
    @Contract(pure=true)
    public Set<RegistryKey> keys();

    public TypeKey<T> getType();

    default public Class<? super T> getRawType() {
        return this.getType().getRawType();
    }

    default public Optional<T> getByID(String id) {
        return this.getByID(id, map -> {
            if (map.isEmpty()) {
                return Optional.empty();
            }
            if (map.size() == 1) {
                return map.values().stream().findFirst();
            }
            throw new IllegalArgumentException("ID \"" + id + "\" is ambiguous; matches: " + map.keySet().stream().map(RegistryKey::toString).reduce("", (a2, b2) -> a2 + "\n - " + b2));
        });
    }

    default public Collection<T> getAllWithID(String id) {
        return this.getMatches(id).values();
    }

    public Map<RegistryKey, T> getMatches(String var1);

    default public Optional<T> getByID(String attempt, Function<Map<RegistryKey, T>, Optional<T>> reduction) {
        if (attempt.contains(":")) {
            return this.get(RegistryKey.parse(attempt));
        }
        return reduction.apply(this.getMatches(attempt));
    }
}

