/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit.parsers.selector;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.bukkit.arguments.selector.MultiplePlayerSelector;
import cloud.commandframework.bukkit.parsers.PlayerArgument;
import cloud.commandframework.bukkit.parsers.selector.SelectorUtils;
import cloud.commandframework.context.CommandContext;
import com.dfsek.terra.lib.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MultiplePlayerSelectorArgument<C>
extends CommandArgument<C, MultiplePlayerSelector> {
    private MultiplePlayerSelectorArgument(boolean allowEmpty, boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new MultiplePlayerSelectorParser(allowEmpty), defaultValue, MultiplePlayerSelector.class, suggestionsProvider, defaultDescription);
    }

    @API(status=API.Status.DEPRECATED, since="1.8.0")
    @Deprecated
    public static <C> Builder<C> newBuilder(@NonNull String name) {
        return MultiplePlayerSelectorArgument.builder(name);
    }

    @API(status=API.Status.STABLE, since="1.8.0")
    public static <C> @NonNull Builder<C> builder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull MultiplePlayerSelectorArgument<C> of(@NonNull String name) {
        return ((Builder)MultiplePlayerSelectorArgument.builder(name).asRequired()).build();
    }

    public static <C> @NonNull MultiplePlayerSelectorArgument<C> optional(@NonNull String name) {
        return ((Builder)MultiplePlayerSelectorArgument.builder(name).asOptional()).build();
    }

    public static <C> @NonNull MultiplePlayerSelectorArgument<C> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return ((Builder)MultiplePlayerSelectorArgument.builder(name).asOptionalWithDefault(defaultEntitySelector)).build();
    }

    public static final class MultiplePlayerSelectorParser<C>
    extends SelectorUtils.PlayerSelectorParser<C, MultiplePlayerSelector> {
        private final boolean allowEmpty;

        @API(status=API.Status.STABLE, since="1.8.0")
        public MultiplePlayerSelectorParser(boolean allowEmpty) {
            super(false);
            this.allowEmpty = allowEmpty;
        }

        public MultiplePlayerSelectorParser() {
            this(true);
        }

        @Override
        public MultiplePlayerSelector mapResult(@NonNull String input,  @NonNull SelectorUtils.EntitySelectorWrapper wrapper) {
            List<Player> players = wrapper.players();
            if (players.isEmpty() && !this.allowEmpty) {
                new SelectorUtils.SelectorParser.Thrower(NO_PLAYERS_EXCEPTION_TYPE.get()).throwIt();
            }
            return new MultiplePlayerSelector(input, new ArrayList<Player>(players));
        }

        @Override
        protected @NonNull ArgumentParseResult<MultiplePlayerSelector> legacyParse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            String input = inputQueue.peek();
            @Nullable Player player = Bukkit.getPlayer((String)input);
            if (player == null) {
                return ArgumentParseResult.failure(new PlayerArgument.PlayerParseException(input, commandContext));
            }
            inputQueue.remove();
            return ArgumentParseResult.success(new MultiplePlayerSelector(input, ImmutableList.of(player)));
        }
    }

    public static final class Builder<C>
    extends CommandArgument.TypedBuilder<C, MultiplePlayerSelector, Builder<C>> {
        private boolean allowEmpty = true;

        private Builder(@NonNull String name) {
            super(MultiplePlayerSelector.class, name);
        }

        @API(status=API.Status.STABLE, since="1.8.0")
        public @NonNull Builder<C> allowEmpty(boolean allowEmpty) {
            this.allowEmpty = allowEmpty;
            return this;
        }

        public @NonNull MultiplePlayerSelectorArgument<C> build() {
            return new MultiplePlayerSelectorArgument(this.allowEmpty, this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

