/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.bukkit;

import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.standard.UUIDArgument;
import cloud.commandframework.brigadier.CloudBrigadierManager;
import cloud.commandframework.bukkit.BukkitCommandManager;
import cloud.commandframework.bukkit.argument.NamespacedKeyArgument;
import cloud.commandframework.bukkit.internal.CommandBuildContextSupplier;
import cloud.commandframework.bukkit.internal.MinecraftArgumentTypes;
import cloud.commandframework.bukkit.internal.RegistryReflection;
import cloud.commandframework.bukkit.parsers.BlockPredicateArgument;
import cloud.commandframework.bukkit.parsers.EnchantmentArgument;
import cloud.commandframework.bukkit.parsers.ItemStackArgument;
import cloud.commandframework.bukkit.parsers.ItemStackPredicateArgument;
import cloud.commandframework.bukkit.parsers.location.Location2DArgument;
import cloud.commandframework.bukkit.parsers.location.LocationArgument;
import cloud.commandframework.bukkit.parsers.selector.MultipleEntitySelectorArgument;
import cloud.commandframework.bukkit.parsers.selector.MultiplePlayerSelectorArgument;
import cloud.commandframework.bukkit.parsers.selector.SingleEntitySelectorArgument;
import cloud.commandframework.bukkit.parsers.selector.SinglePlayerSelectorArgument;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class BukkitBrigadierMapper<C> {
    private final BukkitCommandManager<C> commandManager;
    private final CloudBrigadierManager<C, ?> brigadierManager;

    public BukkitBrigadierMapper(@NonNull BukkitCommandManager<C> commandManager, @NonNull CloudBrigadierManager<C, ?> brigadierManager) {
        this.commandManager = commandManager;
        this.brigadierManager = brigadierManager;
        this.registerMappings();
    }

    private void registerMappings() {
        try {
            Class<? extends ArgumentType<?>> uuid = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"uuid"));
            this.mapSimpleNMS(new TypeToken<UUIDArgument.UUIDParser<C>>(){}, "uuid");
        }
        catch (IllegalArgumentException uuid) {
            // empty catch block
        }
        this.mapSimpleNMS(new TypeToken<NamespacedKeyArgument.Parser<C>>(){}, "resource_location", true);
        try {
            Class<? extends ArgumentType<?>> ench = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"item_enchantment"));
            this.mapSimpleNMS(new TypeToken<EnchantmentArgument.EnchantmentParser<C>>(){}, "item_enchantment");
        }
        catch (IllegalArgumentException ignore) {
            this.mapNMS(new TypeToken<EnchantmentArgument.EnchantmentParser<C>>(){}, this::modernEnchantment);
        }
        this.mapSimpleContextNMS(new TypeToken<ItemStackArgument.Parser<C>>(){}, "item_stack");
        this.mapSimpleContextNMS(new TypeToken<ItemStackPredicateArgument.Parser<C>>(){}, "item_predicate");
        this.mapSimpleContextNMS(new TypeToken<BlockPredicateArgument.Parser<C>>(){}, "block_predicate");
        this.mapNMS(new TypeToken<SingleEntitySelectorArgument.SingleEntitySelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(true, false));
        this.mapNMS(new TypeToken<SinglePlayerSelectorArgument.SinglePlayerSelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(true, true));
        this.mapNMS(new TypeToken<MultipleEntitySelectorArgument.MultipleEntitySelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(false, false));
        this.mapNMS(new TypeToken<MultiplePlayerSelectorArgument.MultiplePlayerSelectorParser<C>>(){}, this.entitySelectorArgumentSupplier(false, true));
        this.mapNMS(new TypeToken<LocationArgument.LocationParser<C>>(){}, this::argumentVec3);
        this.mapNMS(new TypeToken<Location2DArgument.Location2DParser<C>>(){}, this::argumentVec2);
    }

    private ArgumentType<?> modernEnchantment() {
        try {
            return (ArgumentType)MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"resource_key")).getDeclaredConstructors()[0].newInstance(RegistryReflection.registryKey(RegistryReflection.registryByName("enchantment")));
        }
        catch (Exception e2) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve enchantment argument", e2);
            return BukkitBrigadierMapper.fallbackType();
        }
    }

    private @NonNull Supplier<ArgumentType<?>> entitySelectorArgumentSupplier(boolean single, boolean playersOnly) {
        return () -> {
            try {
                Constructor<?> constructor = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"entity")).getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                return (ArgumentType)constructor.newInstance(single, playersOnly);
            }
            catch (Exception e2) {
                this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Selector Argument", e2);
                return BukkitBrigadierMapper.fallbackType();
            }
        };
    }

    private @NonNull ArgumentType<?> argumentVec3() {
        try {
            return MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"vec3")).getDeclaredConstructor(Boolean.TYPE).newInstance(true);
        }
        catch (Exception e2) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Vec3D argument", e2);
            return BukkitBrigadierMapper.fallbackType();
        }
    }

    private @NonNull ArgumentType<?> argumentVec2() {
        try {
            return MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)"vec2")).getDeclaredConstructor(Boolean.TYPE).newInstance(true);
        }
        catch (Exception e2) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.INFO, "Failed to retrieve Vec2 argument", e2);
            return BukkitBrigadierMapper.fallbackType();
        }
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleContextNMS(@NonNull TypeToken<T> type, @NonNull String argumentId) {
        Constructor<?> ctr = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)argumentId)).getDeclaredConstructors()[0];
        this.mapNMS(type, () -> {
            Object[] objectArray;
            if (ctr.getParameterCount() == 1) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = CommandBuildContextSupplier.commandBuildContext();
            } else {
                objectArray = new Object[]{};
            }
            Object[] args = objectArray;
            try {
                return (ArgumentType)ctr.newInstance(args);
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleNMS(@NonNull TypeToken<T> type, @NonNull String argumentId) {
        this.mapSimpleNMS(type, argumentId, false);
    }

    public <T extends ArgumentParser<C, ?>> void mapSimpleNMS(@NonNull TypeToken<T> type, @NonNull String argumentId, boolean useCloudSuggestions) {
        Constructor<? extends ArgumentType<?>> constructor;
        try {
            Class<ArgumentType<?>> nmsArgument = MinecraftArgumentTypes.getClassByKey(NamespacedKey.minecraft((String)argumentId));
            constructor = nmsArgument.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException | RuntimeException e2) {
            this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, String.format("Failed to create mapping for NMS brigadier argument type '%s'.", argumentId), e2);
            return;
        }
        this.brigadierManager.registerMapping(type, builder -> {
            builder.to(argument -> {
                try {
                    return (ArgumentType)constructor.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e2) {
                    this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, String.format("Failed to create instance of brigadier argument type '%s'.", GenericTypeReflector.erase(type.getType()).getCanonicalName()), e2);
                    return BukkitBrigadierMapper.fallbackType();
                }
            });
            if (useCloudSuggestions) {
                builder.cloudSuggestions();
            }
        });
    }

    public <T extends ArgumentParser<C, ?>> void mapNMS(@NonNull TypeToken<T> type, @NonNull Supplier<ArgumentType<?>> argumentTypeSupplier) {
        this.brigadierManager.registerMapping(type, builder -> builder.to(arg_0 -> BukkitBrigadierMapper.lambda$mapNMS$4((Supplier)argumentTypeSupplier, arg_0)));
    }

    private static @NonNull StringArgumentType fallbackType() {
        return StringArgumentType.word();
    }

    @Deprecated
    public void mapSimpleNMS(@NonNull Class<?> type, @NonNull Constructor<?> constructor) {
        this.brigadierManager.registerDefaultArgumentTypeSupplier(type, () -> {
            try {
                return (ArgumentType)constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e2) {
                this.commandManager.getOwningPlugin().getLogger().log(Level.WARNING, String.format("Failed to map brigadier argument type '%s'", type.getCanonicalName()), e2);
                return BukkitBrigadierMapper.fallbackType();
            }
        });
    }

    @Deprecated
    public void mapComplexNMS(@NonNull Class<?> type, @NonNull Supplier<ArgumentType<?>> argumentTypeSupplier) {
        this.brigadierManager.registerDefaultArgumentTypeSupplier(type, argumentTypeSupplier);
    }

    private static /* synthetic */ ArgumentType lambda$mapNMS$4(Supplier argumentTypeSupplier, ArgumentParser argument) {
        return (ArgumentType)argumentTypeSupplier.get();
    }
}

