/*
 * Decompiled with CFR 0.152.
 */
package ca.solostudios.strata.version;

import ca.solostudios.strata.Versions;
import ca.solostudios.strata.parser.tokenizer.ParseException;
import ca.solostudios.strata.version.Formattable;
import ca.solostudios.strata.version.Version;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VersionRange
implements Formattable {
    @Nullable
    private final Version startVersion;
    private final boolean startInclusive;
    @Nullable
    private final Version endVersion;
    private final boolean endInclusive;

    public VersionRange(@Nullable Version startVersion, boolean startInclusive, @Nullable Version endVersion, boolean endInclusive) {
        this.startVersion = startVersion;
        this.startInclusive = startInclusive;
        this.endVersion = endVersion;
        this.endInclusive = endInclusive;
    }

    @Nullable
    public Version getStartVersion() {
        return this.startVersion;
    }

    public boolean isStartInclusive() {
        return this.startInclusive;
    }

    @Nullable
    public Version getEndVersion() {
        return this.endVersion;
    }

    public boolean isEndInclusive() {
        return this.endInclusive;
    }

    public boolean isSatisfiedBy(String version) throws ParseException {
        return this.isSatisfiedBy(Versions.parseVersion(version));
    }

    public boolean isSatisfiedBy(Version version) {
        if (this.startVersion != null && (this.startInclusive ? 0 < this.startVersion.getCoreVersion().compareTo(version.getCoreVersion()) : 0 <= this.startVersion.getCoreVersion().compareTo(version.getCoreVersion()))) {
            return false;
        }
        if (this.endVersion != null) {
            if (this.endInclusive) {
                return 0 <= this.endVersion.getCoreVersion().compareTo(version.getCoreVersion());
            }
            return 0 < this.endVersion.getCoreVersion().compareTo(version.getCoreVersion());
        }
        return true;
    }

    @Contract(pure=true)
    public String toString() {
        return String.format("VersionRange{startVersion=%s, startInclusive=%b, endVersion=%s, endInclusive=%b}", this.startVersion, this.startInclusive, this.endVersion, this.endInclusive);
    }

    @Override
    @NotNull
    public String getFormatted() {
        StringBuilder sb = new StringBuilder();
        if (this.startInclusive) {
            sb.append('[');
        } else {
            sb.append('(');
        }
        if (this.startVersion != null) {
            sb.append(this.startVersion.getFormatted());
        }
        sb.append(",");
        if (this.endVersion != null) {
            sb.append(this.endVersion.getFormatted());
        }
        return sb.toString();
    }
}

