/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.versions;

import org.bukkit.Bukkit;

public class VersionManager {
    private final int versionCode;

    public VersionManager() {
        String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
        this.versionCode = this.parseVersionCode(version);
    }

    public int parseVersionCode(String version) {
        String[] parts = version.split("\\.");
        int major = parts.length > 0 ? this.parseIntSafe(parts[0]) : 0;
        int minor = parts.length > 1 ? this.parseIntSafe(parts[1]) : 0;
        int patch = parts.length > 2 ? this.parseIntSafe(parts[2]) : 0;
        return major * 1000000 + minor * 1000 + patch;
    }

    private int parseIntSafe(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean isAtLeast(String version) {
        return this.versionCode >= this.parseVersionCode(version);
    }

    public boolean isBelow(String version) {
        return this.versionCode < this.parseVersionCode(version);
    }

    public int getVersionCode() {
        return this.versionCode;
    }
}

