/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.logging.Level;
import me.rockyhawk.commandpanels.Context;

public class FileDownloader {
    private final Context ctx;

    public FileDownloader(Context ctx) {
        this.ctx = ctx;
    }

    public void downloadFile(String version, String pluginFileName) {
        try (BufferedInputStream in = new BufferedInputStream(new URL("https://github.com/rockyhawk64/CommandPanels/releases/download/" + version + "/CommandPanels.jar").openStream());
             FileOutputStream fout = new FileOutputStream(new File(new File(".").getAbsolutePath() + "/plugins/", pluginFileName));){
            int count;
            this.ctx.plugin.getLogger().info("Downloading new update: v" + version);
            byte[] data = new byte[1024];
            long downloaded = 0L;
            int fileLength = new URL("https://github.com/rockyhawk64/CommandPanels/releases/download/" + version + "/CommandPanels.jar").openConnection().getContentLength();
            int lastPercent = 0;
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
                int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                if (percent == lastPercent || percent % 10 != 0) continue;
                this.ctx.plugin.getLogger().info("Downloading update: " + percent + "% " + downloaded + " of " + fileLength + " bytes.");
                lastPercent = percent;
            }
            this.ctx.plugin.getLogger().info("Finished updating.");
        }
        catch (Exception e) {
            this.ctx.plugin.getLogger().log(Level.WARNING, "Could not download update.", e);
        }
    }
}

