/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.updater;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.updater.FileDownloader;
import me.rockyhawk.commandpanels.updater.Updater;

public class AutoUpdater {
    private final Context ctx;
    private final Updater updater;

    public AutoUpdater(Context ctx, Updater updater) {
        this.ctx = ctx;
        this.updater = updater;
    }

    public void autoUpdate(String pluginFileName) {
        String[] latestParts;
        if (!this.ctx.configHandler.isTrue("updater.update-checks")) {
            return;
        }
        String latestVersion = this.updater.cachedLatestVersion;
        String currentVersion = this.ctx.plugin.getDescription().getVersion();
        if (this.updater.downloadVersionManually != null) {
            String version = this.updater.downloadVersionManually.equals("latest") ? latestVersion : this.updater.downloadVersionManually;
            new FileDownloader(this.ctx).downloadFile(version, pluginFileName);
            return;
        }
        if (latestVersion.equals(currentVersion) || currentVersion.contains("-")) {
            return;
        }
        if (!this.ctx.configHandler.isTrue("updater.auto-update")) {
            return;
        }
        String[] currParts = currentVersion.split("\\.");
        if (currParts[0].equals((latestParts = latestVersion.split("\\."))[0]) && currParts[1].equals(latestParts[1])) {
            new FileDownloader(this.ctx).downloadFile(latestVersion, pluginFileName);
        }
    }
}

