/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openwithitem.events;

import java.util.ArrayList;
import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.openwithitem.iteminhand.GetItemInHand;
import me.rockyhawk.commandpanels.openwithitem.iteminhand.GetItemInHandLegacy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class HotbarEvents
implements Listener {
    Context ctx;

    public HotbarEvents(Context pl) {
        this.ctx = pl;
    }

    @EventHandler
    public void onAnyClick(InventoryClickEvent e) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getClick() == ClickType.NUMBER_KEY) {
            int hotbarSlot = e.getHotbarButton();
            ItemStack hotbarItem = p.getInventory().getItem(hotbarSlot);
            if (hotbarItem != null && this.ctx.hotbar.itemCheckExecute(hotbarItem, p, false, false)) {
                e.setCancelled(true);
                if (this.ctx.hotbar.stationaryExecute(hotbarSlot, p, e.getClick(), true)) {
                    p.updateInventory();
                }
                p.getInventory().setItem(hotbarSlot, hotbarItem);
                return;
            }
        }
        if (e.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (e.getSlot() == -999) {
            return;
        }
        if (e.getClickedInventory() == null) {
            return;
        }
        if (e.getClickedInventory().getType() == InventoryType.PLAYER && !e.isCancelled() && this.ctx.hotbar.stationaryExecute(e.getSlot(), p, e.getClick(), true)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onPlayerUse(PlayerInteractEvent e) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        try {
            if (e.getAction() != Action.RIGHT_CLICK_AIR && e.getAction() != Action.RIGHT_CLICK_BLOCK || Objects.requireNonNull(e.getItem()).getType() == Material.AIR) {
                return;
            }
        }
        catch (Exception b) {
            return;
        }
        Player p = e.getPlayer();
        if (this.ctx.hotbar.itemCheckExecute(e.getItem(), p, true, false)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        Player p = e.getPlayer();
        if (Bukkit.getVersion().contains("1.8")) {
            if (this.ctx.hotbar.itemCheckExecute(e.getPlayer().getItemInHand(), p, false, false)) {
                e.setCancelled(true);
                p.updateInventory();
            }
        } else if (this.ctx.hotbar.itemCheckExecute(e.getPlayer().getInventory().getItemInMainHand(), p, false, false)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        this.ctx.hotbar.updateHotbarItems(e.getPlayer());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
        this.ctx.hotbar.updateHotbarItems(e.getPlayer());
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        try {
            for (ItemStack s : new ArrayList(e.getDrops())) {
                try {
                    if (this.ctx.nbt.getNBTValue(s, "CommandPanelsHotbar") == null || String.valueOf(this.ctx.nbt.getNBTValue(s, "CommandPanelsHotbar")).isEmpty() || String.valueOf(this.ctx.nbt.getNBTValue(s, "CommandPanelsHotbar")).endsWith("-1")) continue;
                    e.getDrops().remove(s);
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.ctx.hotbar.updateHotbarItems(e.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        this.ctx.hotbar.stationaryItems.remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent e) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        Player p = e.getPlayer();
        if (this.ctx.hotbar.itemCheckExecute(e.getItemDrop().getItemStack(), p, false, true)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack clicked = Bukkit.getVersion().contains("1.8") ? new GetItemInHandLegacy().itemInHand(p) : new GetItemInHand().itemInHand(p);
        if (this.ctx.hotbar.itemCheckExecute(clicked, p, true, false)) {
            e.setCancelled(true);
            p.updateInventory();
        }
    }
}

