/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openwithitem;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import me.rockyhawk.commandpanels.openwithitem.GiveHotbarItem;
import me.rockyhawk.commandpanels.openwithitem.PlayerManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class HotbarItemLoader {
    private final Context ctx;
    public GiveHotbarItem give;
    public HashMap<UUID, PlayerManager> stationaryItems = new HashMap();

    public HotbarItemLoader(Context pl) {
        this.ctx = pl;
        this.give = new GiveHotbarItem(this.ctx);
        this.reloadHotbarSlots();
    }

    public void reloadHotbarSlots() {
        this.stationaryItems.clear();
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.ctx.hotbar.updateHotbarItems(p);
        }
    }

    public boolean stationaryExecute(int slot, Player p, ClickType click, boolean openPanel) {
        if (this.stationaryItems.get((Object)p.getUniqueId()).list.containsKey(String.valueOf(slot))) {
            if (openPanel) {
                try {
                    if (this.ctx.nbt.getNBTValue(p.getInventory().getItem(slot), "CommandPanelsHotbar") != null && !String.valueOf(this.ctx.nbt.getNBTValue(p.getInventory().getItem(slot), "CommandPanelsHotbar")).split(":")[1].equals(String.valueOf(slot))) {
                        return false;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
                Panel panel = this.stationaryItems.get(p.getUniqueId()).getPanel(String.valueOf(slot));
                if (!p.hasPermission("commandpanel.panel." + panel.getConfig().getString("perm"))) {
                    return false;
                }
                if (!this.itemCheckExecute(p.getInventory().getItem(slot), p, false, false)) {
                    return false;
                }
                if (panel.getHotbarSection(p).contains("commands")) {
                    this.ctx.commands.runCommands(panel, PanelPosition.Top, p, panel.getHotbarSection(p).getStringList("commands"), click);
                    return true;
                }
                panel.open(p, PanelPosition.Top);
            }
            return true;
        }
        return false;
    }

    public boolean itemCheckExecute(ItemStack invItem, Player p, boolean openPanel, boolean stationaryOnly) {
        try {
            if (Objects.equals(String.valueOf(this.ctx.nbt.getNBTValue(invItem, "CommandPanelsHotbar")), "")) {
                return false;
            }
        }
        catch (IllegalArgumentException | NullPointerException nu) {
            return false;
        }
        for (Panel panel : this.ctx.plugin.panelList) {
            if (stationaryOnly) {
                try {
                    if (this.ctx.nbt.getNBTValue(invItem, "CommandPanelsHotbar") != null && String.valueOf(this.ctx.nbt.getNBTValue(invItem, "CommandPanelsHotbar")).split(":")[1].equals("-1")) {
                        continue;
                    }
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
            if (!panel.hasHotbarItem() || this.ctx.nbt.getNBTValue(invItem, "CommandPanelsHotbar") == null || !String.valueOf(this.ctx.nbt.getNBTValue(invItem, "CommandPanelsHotbar")).split(":")[0].equals(panel.getName())) continue;
            if (openPanel) {
                if (!this.ctx.openPanel.permission.isPanelWorldEnabled(p, panel.getConfig())) {
                    return false;
                }
                if (panel.getHotbarSection(p).contains("commands")) {
                    for (String command : panel.getHotbarSection(p).getStringList("commands")) {
                        this.ctx.commands.runCommand(panel, PanelPosition.Top, p, command);
                    }
                    return true;
                }
                panel.open(p, PanelPosition.Top);
            }
            return true;
        }
        return false;
    }

    public void updateHotbarItems(Player p) {
        if (!this.ctx.plugin.openWithItem) {
            return;
        }
        this.stationaryItems.put(p.getUniqueId(), new PlayerManager());
        for (int i = 0; i <= 35; ++i) {
            try {
                if (this.ctx.nbt.getNBTValue(p.getInventory().getItem(i), "CommandPanelsHotbar") == null || Objects.equals(String.valueOf(this.ctx.nbt.getNBTValue(p.getInventory().getItem(i), "CommandPanelsHotbar")), "") || String.valueOf(this.ctx.nbt.getNBTValue(p.getInventory().getItem(i), "CommandPanelsHotbar")).endsWith("-1")) continue;
                p.getInventory().setItem(i, new ItemStack(Material.AIR));
                continue;
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        for (Panel panel : this.ctx.plugin.panelList) {
            if (!this.ctx.openPanel.permission.isPanelWorldEnabled(p, panel.getConfig()) || !p.hasPermission("commandpanel.panel." + panel.getConfig().getString("perm")) || !panel.hasHotbarItem()) continue;
            ItemStack s = panel.getHotbarItem(p);
            if (!panel.getHotbarSection(p).contains("stationary")) continue;
            p.getInventory().setItem(Integer.parseInt(panel.getHotbarSection(p).getString("stationary")), s);
            this.stationaryItems.get(p.getUniqueId()).addSlot(panel.getHotbarSection(p).getString("stationary"), panel);
        }
        p.updateInventory();
    }
}

