/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.nbt;

import java.util.Map;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import me.rockyhawk.commandpanels.nbt.NBTHandler;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PersistentDataHandler
implements NBTHandler {
    private final Plugin plugin;

    public PersistentDataHandler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean hasSameNBT(ItemStack one, ItemStack two) {
        return this.getAllKeys(one).equals(this.getAllKeys(two));
    }

    @Override
    public boolean hasNBT(ItemStack item, String key) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        return container.has(new NamespacedKey(this.plugin, key), PersistentDataType.STRING);
    }

    @Override
    public ItemStack setNBT(ItemStack item, String key, Object value) {
        if (item == null || item.getType() == Material.AIR) {
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.getPersistentDataContainer().set(new NamespacedKey(this.plugin, key), PersistentDataType.STRING, (Object)value.toString());
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public Object getNBTValue(ItemStack item, String key) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        return container.get(new NamespacedKey(this.plugin, key), PersistentDataType.STRING);
    }

    private String getAllKeys(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return "";
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        return container.getKeys().toString();
    }

    @Override
    public void applyNBTRecursively(ItemStack item, ConfigurationSection section, Player player, Panel panel, PanelPosition position) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        this.applySectionToContainer(container, section);
        item.setItemMeta(meta);
    }

    private void applySectionToContainer(PersistentDataContainer container, ConfigurationSection section) {
        for (String key : section.getKeys(false)) {
            Object value = section.get(key);
            if (section.isConfigurationSection(key)) {
                NamespacedKey nsKey = new NamespacedKey("myplugin", key);
                PersistentDataContainer subContainer = container.getAdapterContext().newPersistentDataContainer();
                this.applySectionToContainer(subContainer, section.getConfigurationSection(key));
                container.set(nsKey, PersistentDataType.TAG_CONTAINER, (Object)subContainer);
                continue;
            }
            this.setValueInContainer(container, key, value);
        }
    }

    private void setValueInContainer(PersistentDataContainer container, String key, Object value) {
        NamespacedKey nsKey = new NamespacedKey("myplugin", key);
        if (value instanceof Boolean) {
            container.set(nsKey, PersistentDataType.BYTE, (Object)((byte)((Boolean)value != false ? 1 : 0)));
        } else if (value instanceof Integer) {
            container.set(nsKey, PersistentDataType.INTEGER, (Object)((Integer)value));
        } else if (value instanceof Double) {
            container.set(nsKey, PersistentDataType.DOUBLE, (Object)((Double)value));
        } else if (value instanceof Long) {
            container.set(nsKey, PersistentDataType.LONG, (Object)((Long)value));
        } else if (value instanceof Float) {
            container.set(nsKey, PersistentDataType.FLOAT, (Object)((Float)value));
        } else if (value instanceof Byte) {
            container.set(nsKey, PersistentDataType.BYTE, (Object)((Byte)value));
        } else {
            container.set(nsKey, PersistentDataType.STRING, (Object)value.toString());
        }
    }

    @Override
    public void saveMapToYAML(Map<String, Object> map, ConfigurationSection section) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                ConfigurationSection newSection = section.createSection(entry.getKey());
                this.saveMapToYAML((Map)value, newSection);
                continue;
            }
            if (value instanceof Byte) {
                byte byteValue = (Byte)value;
                if (byteValue == 1 || byteValue == 0) {
                    section.set(entry.getKey(), (Object)(byteValue == 1 ? 1 : 0));
                    continue;
                }
                section.set(entry.getKey(), (Object)byteValue);
                continue;
            }
            section.set(entry.getKey(), value);
        }
    }
}

