/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.nbt;

import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import me.rockyhawk.commandpanels.nbt.NBTAPIHandler;
import me.rockyhawk.commandpanels.nbt.NBTHandler;
import me.rockyhawk.commandpanels.nbt.PersistentDataHandler;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NBTManager {
    private final NBTHandler handler;

    public NBTManager(Context ctx) {
        NBTHandler nbtHandler;
        try {
            nbtHandler = new NBTAPIHandler();
            ItemStack test = new ItemStack(Material.STONE);
            String testKey = "nbt_test_key";
            String testValue = "hello";
            ItemStack modified = nbtHandler.setNBT(test, testKey, testValue);
            Object result = nbtHandler.getNBTValue(modified, testKey);
            if (result == null || !result.equals(testValue)) {
                throw new IllegalStateException("NBTAPI test failed \u2013 values didn't match.");
            }
        }
        catch (Throwable ex) {
            ctx.plugin.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[CommandPanels] NBTAPI Error: version being used may not be compatible with this version of Minecraft. Falling back to use PersistentData.");
            nbtHandler = new PersistentDataHandler((Plugin)ctx.plugin);
        }
        this.handler = nbtHandler;
    }

    public boolean hasSameNBT(ItemStack one, ItemStack two) {
        return this.handler.hasSameNBT(one, two);
    }

    public boolean hasNBT(ItemStack item, String key) {
        return this.handler.hasNBT(item, key);
    }

    public ItemStack setNBT(ItemStack item, String key, Object value) {
        return this.handler.setNBT(item, key, value);
    }

    public Object getNBTValue(ItemStack item, String key) {
        return this.handler.getNBTValue(item, key);
    }

    public void applyNBTRecursively(ItemStack item, ConfigurationSection section, Player player, Panel panel, PanelPosition position) {
        this.handler.applyNBTRecursively(item, section, player, panel, position);
    }

    public void saveMapToYAML(Map<String, Object> map, ConfigurationSection section) {
        this.handler.saveMapToYAML(map, section);
    }
}

