/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.nbt;

import java.util.LinkedHashMap;
import java.util.Map;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.libs.nbtapi.NBTCompound;
import me.rockyhawk.commandpanels.libs.nbtapi.NBTItem;
import me.rockyhawk.commandpanels.libs.nbtapi.NBTType;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import me.rockyhawk.commandpanels.nbt.NBTHandler;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NBTAPIHandler
implements NBTHandler {
    @Override
    public boolean hasSameNBT(ItemStack one, ItemStack two) {
        return new NBTItem(one).equals(new NBTItem(two));
    }

    @Override
    public boolean hasNBT(ItemStack item, String key) {
        return new NBTItem(item).hasTag(key);
    }

    @Override
    public ItemStack setNBT(ItemStack item, String key, Object value) {
        if (item == null || item.getType() == Material.AIR) {
            return item;
        }
        NBTItem nbtItem = new NBTItem(item);
        this.setNBTValue(nbtItem, key, value);
        item.setItemMeta(nbtItem.getItem().getItemMeta());
        return item;
    }

    @Override
    public void applyNBTRecursively(ItemStack item, ConfigurationSection section, Player player, Panel panel, PanelPosition position) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        NBTItem nbtItem = new NBTItem(item);
        for (String key : section.getKeys(false)) {
            Object value = section.get(key);
            if (section.isConfigurationSection(key)) {
                NBTCompound compound = nbtItem.addCompound(key);
                this.convertSectionToNBT(compound, section.getConfigurationSection(key), player, panel, position);
                continue;
            }
            this.setNBTValue(nbtItem, key, value);
        }
        item.setItemMeta(nbtItem.getItem().getItemMeta());
    }

    @Override
    public void saveMapToYAML(Map<String, Object> map, ConfigurationSection section) {
        if (map == null || section == null) {
            return;
        }
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                this.saveMapToYAML((Map)value, section.createSection(key));
            } else if (value instanceof Byte) {
                byte byteValue = (Byte)value;
                if (byteValue == 1 || byteValue == 0) {
                    section.set(key, (Object)(byteValue == 1 ? 1 : 0));
                } else {
                    section.set(key, (Object)byteValue);
                }
            } else {
                section.set(key, value);
            }
        });
    }

    private void convertSectionToNBT(NBTCompound compound, ConfigurationSection section, Player player, Panel panel, PanelPosition position) {
        for (String key : section.getKeys(false)) {
            Object value = section.get(key);
            if (section.isConfigurationSection(key)) {
                this.convertSectionToNBT(compound.addCompound(key), section.getConfigurationSection(key), player, panel, position);
                continue;
            }
            this.setNBTValue(compound, key, value);
        }
    }

    private void setNBTValue(NBTCompound compound, String key, Object value) {
        if (value instanceof Boolean) {
            compound.setByte(key, (Boolean)value != false ? (byte)1 : 0);
        } else if (value instanceof Integer) {
            compound.setInteger(key, (Integer)value);
        } else if (value instanceof Double) {
            compound.setDouble(key, (Double)value);
        } else if (value instanceof Long) {
            compound.setLong(key, (Long)value);
        } else if (value instanceof Short) {
            compound.setShort(key, (Short)value);
        } else if (value instanceof Float) {
            compound.setFloat(key, (Float)value);
        } else if (value instanceof Byte) {
            compound.setByte(key, (Byte)value);
        } else if (value instanceof Map) {
            this.saveMapToNBTCompound((Map)value, compound.addCompound(key));
        } else {
            compound.setString(key, value.toString());
        }
    }

    @Override
    public Object getNBTValue(ItemStack item, String key) {
        if (item == null || item.getType() == Material.AIR) {
            return null;
        }
        NBTItem nbtItem = new NBTItem(item);
        if (!nbtItem.hasTag(key)) {
            return null;
        }
        return this.extractNBTValue(nbtItem, key, nbtItem.getType(key));
    }

    private Object extractNBTValue(NBTCompound compound, String key, NBTType type) {
        switch (type) {
            case NBTTagInt: {
                return compound.getInteger(key);
            }
            case NBTTagDouble: {
                return compound.getDouble(key);
            }
            case NBTTagByte: {
                byte byteValue = compound.getByte(key);
                if (byteValue == 1 || byteValue == 0) {
                    return byteValue == 1;
                }
                return byteValue;
            }
            case NBTTagFloat: {
                return compound.getFloat(key);
            }
            case NBTTagLong: {
                return compound.getLong(key);
            }
            case NBTTagShort: {
                return compound.getShort(key);
            }
            case NBTTagByteArray: {
                return compound.getByteArray(key);
            }
            case NBTTagIntArray: {
                return compound.getIntArray(key);
            }
            case NBTTagList: {
                return compound.getStringList(key);
            }
            case NBTTagCompound: {
                return this.convertCompoundToMap(compound.getCompound(key));
            }
            case NBTTagString: {
                String str = compound.getString(key);
                if (str.equalsIgnoreCase("true")) {
                    return true;
                }
                if (str.equalsIgnoreCase("false")) {
                    return false;
                }
                if (str.matches("-?\\d+")) {
                    return Integer.parseInt(str);
                }
                if (str.matches("-?\\d+\\.\\d+")) {
                    return Double.parseDouble(str);
                }
                return str;
            }
        }
        return null;
    }

    private Map<String, Object> convertCompoundToMap(NBTCompound compound) {
        LinkedHashMap<String, Object> compoundMap = new LinkedHashMap<String, Object>();
        compound.getKeys().forEach(key -> compoundMap.put((String)key, this.extractNBTValue(compound, (String)key, compound.getType((String)key))));
        return compoundMap;
    }

    private void saveMapToNBTCompound(Map<String, Object> map, NBTCompound compound) {
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                this.saveMapToNBTCompound((Map)value, compound.addCompound((String)key));
            } else {
                this.setNBTValue(compound, (String)key, value);
            }
        });
    }
}

