/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.manager.session;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.events.PanelClosedEvent;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class SessionUtils
implements Listener {
    Context ctx;

    public SessionUtils(Context pl) {
        this.ctx = pl;
    }

    @EventHandler
    public void onPlayerClosePanel(PlayerQuitEvent e) {
        this.ctx.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
        Player p = e.getPlayer();
        p.updateInventory();
        this.ctx.openPanels.deleteCommandPanelsItems(p);
    }

    @EventHandler
    public void onPlayerClosePanel(InventoryCloseEvent e) {
        final String playerName = e.getPlayer().getName();
        if (!this.ctx.openPanels.openPanels.containsKey(playerName) || this.ctx.openPanels.skipPanelClose.contains(playerName)) {
            return;
        }
        if (this.ctx.openPanels.getOpenPanel(playerName, PanelPosition.Top).getConfig().contains("panelType") && this.ctx.openPanels.getOpenPanel(playerName, PanelPosition.Top).getConfig().getStringList("panelType").contains("unclosable")) {
            this.ctx.scheduler.runTaskForEntity((Entity)((Player)e.getPlayer()), new Runnable(){

                @Override
                public void run() {
                    if (SessionUtils.this.ctx.openPanels.getOpenPanel(playerName, PanelPosition.Top) == null) {
                        return;
                    }
                    SessionUtils.this.ctx.openPanels.getOpenPanel((String)playerName, (PanelPosition)PanelPosition.Top).isOpen = false;
                    Panel reopenedPanel = SessionUtils.this.ctx.openPanels.getOpenPanel(playerName, PanelPosition.Top).copy();
                    reopenedPanel.placeholders.keys = SessionUtils.this.ctx.openPanels.getOpenPanel((String)playerName, (PanelPosition)PanelPosition.Top).placeholders.keys;
                    reopenedPanel.open(Bukkit.getPlayer((String)playerName), PanelPosition.Top);
                }
            });
            return;
        }
        if (this.ctx.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Bottom)) {
            this.ctx.openPanels.panelCloseCommands(playerName, PanelPosition.Bottom, this.ctx.openPanels.getOpenPanel(playerName, PanelPosition.Bottom));
        }
        if (this.ctx.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Middle)) {
            this.ctx.openPanels.panelCloseCommands(playerName, PanelPosition.Middle, this.ctx.openPanels.getOpenPanel(playerName, PanelPosition.Middle));
        }
        this.ctx.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
    }

    @EventHandler
    public void onInventoryItemClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            if (e.getCurrentItem() == null) {
                return;
            }
            if (e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (this.ctx.openPanels.isCommandPanelsItem(e.getCurrentItem())) {
                p.getInventory().remove(e.getCurrentItem());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void vanillaOpenedEvent(InventoryOpenEvent e) {
        if (e.isCancelled() && this.ctx.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Top)) {
            Panel closedPanel = this.ctx.openPanels.getOpenPanel(e.getPlayer().getName(), PanelPosition.Top);
            this.ctx.openPanels.removePlayer(e.getPlayer().getName());
            PanelClosedEvent closedEvent = new PanelClosedEvent(Bukkit.getPlayer((String)e.getPlayer().getName()), closedPanel, PanelPosition.Top);
            Bukkit.getPluginManager().callEvent((Event)closedEvent);
            if (this.ctx.configHandler.isTrue("config.panel-snooper")) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + e.getPlayer().getName() + "'s Panel was Force Closed");
            }
        }
    }
}

