/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.manager.session;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.PanelInterface;
import me.rockyhawk.commandpanels.api.events.PanelClosedEvent;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class SessionHandler {
    Context ctx;
    public HashMap<String, PanelInterface> openPanels = new HashMap();
    public HashSet<String> skipPanelClose = new HashSet();

    public SessionHandler(Context pl) {
        this.ctx = pl;
    }

    public Panel getOpenPanel(String playerName, PanelPosition position) {
        for (Map.Entry<String, PanelInterface> entry : this.openPanels.entrySet()) {
            if (!entry.getKey().equals(playerName)) continue;
            return entry.getValue().getPanel(position);
        }
        return null;
    }

    public boolean hasPanelOpen(String playerName, String panelName, PanelPosition position) {
        for (Map.Entry<String, PanelInterface> entry : this.openPanels.entrySet()) {
            try {
                if (!entry.getKey().equals(playerName) || !entry.getValue().getPanel(position).getName().equals(panelName)) continue;
                return true;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return false;
    }

    public boolean hasPanelOpen(String playerName, PanelPosition position) {
        for (Map.Entry<String, PanelInterface> entry : this.openPanels.entrySet()) {
            try {
                if (!entry.getKey().equals(playerName) || entry.getValue().getPanel(position) == null) continue;
                return true;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return false;
    }

    public void openPanelForLoader(String playerName, Panel panel, PanelPosition position) {
        if (!this.openPanels.containsKey(playerName)) {
            this.openPanels.put(playerName, new PanelInterface(playerName));
        }
        this.openPanels.get(playerName).setPanel(panel, position);
        this.openPanels.get((Object)playerName).getPanel((PanelPosition)position).isOpen = true;
        if (this.ctx.configHandler.isTrue("config.panel-snooper")) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + playerName + " Opened " + panel.getName() + " at " + (Object)((Object)position));
        }
    }

    public void closePanelForLoader(String playerName, PanelPosition position) {
        if (!this.ctx.openPanels.openPanels.containsKey(playerName) || this.ctx.openPanels.skipPanelClose.contains(playerName)) {
            return;
        }
        if (this.ctx.configHandler.isTrue("config.panel-snooper")) {
            Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + playerName + " Closed " + this.openPanels.get(playerName).getPanel(position).getName() + " at " + (Object)((Object)position));
        }
        Panel panel = this.openPanels.get(playerName).getPanel(position);
        this.panelCloseCommands(playerName, position, panel);
        PanelClosedEvent closedEvent = new PanelClosedEvent(Bukkit.getPlayer((String)playerName), panel, position);
        Bukkit.getPluginManager().callEvent((Event)closedEvent);
        this.ctx.scheduler.runTaskAsynchronously(() -> this.ctx.panelData.saveDataFile());
        this.openPanels.get(playerName).setPanel(null, position);
        if (this.openPanels.get(playerName).allClosed()) {
            this.removePlayer(playerName);
        } else if (this.openPanels.get(playerName).getPanel(PanelPosition.Top) == null) {
            this.removePlayer(playerName);
        }
        this.ctx.inventorySaver.restoreInventory(Bukkit.getPlayer((String)playerName), position);
    }

    public void removePlayer(String playerName) {
        this.openPanels.get(playerName).setPanel(null, PanelPosition.Top);
        this.openPanels.get(playerName).setPanel(null, PanelPosition.Middle);
        this.openPanels.get(playerName).setPanel(null, PanelPosition.Bottom);
        this.openPanels.remove(playerName);
    }

    public void panelCloseCommands(String playerName, PanelPosition position, Panel panel) {
        if (panel.getConfig().contains("commands-on-close")) {
            try {
                this.ctx.commands.runCommands(panel, position, Bukkit.getPlayer((String)playerName), panel.getConfig().getStringList("commands-on-close"), null);
            }
            catch (Exception s) {
                this.ctx.debug.send(s, null, this.ctx);
            }
        }
    }

    public void deleteCommandPanelsItems(Player p) {
        for (ItemStack itm : p.getInventory().getContents()) {
            if (itm == null || !this.ctx.nbt.hasNBT(itm, "CommandPanelsItem")) continue;
            p.getInventory().remove(itm);
        }
    }

    public boolean isCommandPanelsItem(ItemStack itm) {
        if (itm != null) {
            return this.ctx.nbt.hasNBT(itm, "CommandPanelsItem");
        }
        return false;
    }
}

