/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.manager.refresh;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerAdapter {
    private final Plugin plugin;
    private final boolean isFolia;

    public SchedulerAdapter(Plugin plugin) {
        this.plugin = plugin;
        this.isFolia = this.isFoliaServer();
    }

    private boolean isFoliaServer() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public BukkitTask runTask(Runnable task) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().run(this.plugin, scheduledTask -> task.run());
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTask(this.plugin, task);
    }

    public BukkitTask runTaskLater(Runnable task, long delay) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), delay);
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTaskLater(this.plugin, task, delay);
    }

    public BukkitTask runTaskForEntity(Entity entity, Runnable task) {
        if (this.isFolia) {
            entity.getScheduler().run(this.plugin, scheduledTask -> task.run(), null);
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTask(this.plugin, task);
    }

    public BukkitTask runTaskLaterForEntity(Entity entity, Runnable task, long delay) {
        if (this.isFolia) {
            entity.getScheduler().runDelayed(this.plugin, scheduledTask -> task.run(), null, delay);
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTaskLater(this.plugin, task, delay);
    }

    public BukkitTask runTaskForLocation(Location location, Runnable task) {
        if (this.isFolia) {
            Bukkit.getRegionScheduler().run(this.plugin, location, scheduledTask -> task.run());
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTask(this.plugin, task);
    }

    public BukkitTask runTaskLaterForLocation(Location location, Runnable task, long delay) {
        if (this.isFolia) {
            Bukkit.getRegionScheduler().runDelayed(this.plugin, location, scheduledTask -> task.run(), delay);
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTaskLater(this.plugin, task, delay);
    }

    public BukkitTask runTaskAsynchronously(Runnable task) {
        if (this.isFolia) {
            Bukkit.getAsyncScheduler().runNow(this.plugin, scheduledTask -> task.run());
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
    }

    public BukkitTask runTaskTimer(Runnable task, long delay, long period) {
        if (this.isFolia) {
            Bukkit.getGlobalRegionScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), delay, period);
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTaskTimer(this.plugin, task, delay, period);
    }

    public BukkitTask runTaskTimerForEntity(Entity entity, Runnable task, long delay, long period) {
        if (this.isFolia) {
            entity.getScheduler().runAtFixedRate(this.plugin, scheduledTask -> task.run(), null, delay, period);
            return new DummyBukkitTask();
        }
        return Bukkit.getScheduler().runTaskTimer(this.plugin, task, delay, period);
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    private static class DummyBukkitTask
    implements BukkitTask {
        private boolean cancelled = false;

        private DummyBukkitTask() {
        }

        public int getTaskId() {
            return -1;
        }

        public Plugin getOwner() {
            return null;
        }

        public boolean isSync() {
            return false;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

