/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.manager.refresh;

import java.io.File;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.events.PanelOpenedEvent;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitTask;

public class RefreshTask
implements Runnable {
    private final Context ctx;
    private final PanelOpenedEvent event;
    private final Panel panel;
    private final Player player;
    private final int refreshDelay;
    private final int animateValue;
    private int tickCounter = 0;
    private int animateCounter = 0;
    private final PanelBuilder builder;
    private BukkitTask task;

    public RefreshTask(Context ctx, PanelOpenedEvent event, Panel panel, Player player, int refreshDelay, int animateValue) {
        this.ctx = ctx;
        this.event = event;
        this.panel = panel;
        this.player = player;
        this.refreshDelay = refreshDelay;
        this.animateValue = animateValue;
        this.builder = new PanelBuilder(ctx);
    }

    @Override
    public void run() {
        if (!this.panel.isOpen || this.player.getOpenInventory().getTopInventory().getHolder() != this.player) {
            this.stopPanel();
            return;
        }
        if (this.tickCounter++ >= this.refreshDelay) {
            this.tickCounter = 0;
            if (this.animateValue != -1) {
                this.animateCounter = (this.animateCounter + 1) % (this.animateValue + 1);
            }
            try {
                if (this.ctx.debug.isEnabled(this.player) && this.panel.getFile() != null) {
                    this.panel.setConfig((ConfigurationSection)YamlConfiguration.loadConfiguration((File)this.panel.getFile()));
                }
                this.builder.refreshInv(this.panel, this.player, this.event.getPosition(), this.animateCounter);
            }
            catch (Exception e) {
                this.player.closeInventory();
                this.ctx.openPanels.closePanelForLoader(this.player.getName(), this.event.getPosition());
                this.stop();
            }
        }
    }

    private void stopPanel() {
        if (this.ctx.configHandler.isTrue("config.stop-sound")) {
            try {
                String soundName = this.panel.getConfig().getString("sound-on-open");
                if (soundName != null) {
                    this.player.stopSound(Sound.valueOf((String)soundName.toUpperCase()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.player.updateInventory();
        this.removeCommandPanelsItems();
        this.stop();
    }

    private void removeCommandPanelsItems() {
        if (this.ctx.inventorySaver.hasNormalInventory(this.player)) {
            for (ItemStack item : this.player.getInventory().getContents()) {
                if (item == null || !this.ctx.nbt.hasNBT(item, "CommandPanelsItem")) continue;
                this.player.getInventory().remove(item);
            }
        }
    }

    public void start() {
        this.task = this.ctx.scheduler.runTaskTimerForEntity((Entity)this.player, this, 1L, 1L);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

