/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.manager.open;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class PermissionValidator {
    private final Context ctx;

    public PermissionValidator(Context ctx) {
        this.ctx = ctx;
    }

    public boolean hasPermission(CommandSender sender, Player p, Panel panel, PanelPosition position, boolean openForOtherUser) {
        String permMessage = panel.getConfig().getString("custom-messages.perms");
        String defaultPerm = this.ctx.configHandler.config.getString("config.format.perms");
        if (!sender.hasPermission("commandpanel.panel." + panel.getConfig().getString("perm"))) {
            sender.sendMessage(this.ctx.text.colour(this.ctx.tag + (permMessage != null ? permMessage : defaultPerm)));
            return false;
        }
        if (sender.hasPermission("commandpanel.other") || !openForOtherUser) {
            if (!this.isPanelWorldEnabled(p, panel.getConfig())) {
                sender.sendMessage(this.ctx.text.colour(this.ctx.tag + (permMessage != null ? permMessage : defaultPerm)));
                return false;
            }
            return true;
        }
        sender.sendMessage(this.ctx.text.colour(this.ctx.tag + (permMessage != null ? permMessage : defaultPerm)));
        return false;
    }

    public boolean isPanelWorldEnabled(Player p, ConfigurationSection panelConfig) {
        if (panelConfig.contains("disabled-worlds")) {
            return !panelConfig.getStringList("disabled-worlds").contains(p.getWorld().getName());
        }
        if (panelConfig.contains("enabled-worlds")) {
            return panelConfig.getStringList("enabled-worlds").contains(p.getWorld().getName());
        }
        return true;
    }
}

