/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.manager.open;

import java.io.File;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.events.PanelOpenedEvent;
import me.rockyhawk.commandpanels.builder.PanelBuilder;
import me.rockyhawk.commandpanels.manager.open.OpenRequirements;
import me.rockyhawk.commandpanels.manager.open.PanelCommandExecutor;
import me.rockyhawk.commandpanels.manager.open.PermissionValidator;
import me.rockyhawk.commandpanels.manager.open.PreLoadCommands;
import me.rockyhawk.commandpanels.manager.open.SoundHandler;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;

public class OpenPanel {
    public final PermissionValidator permission;
    private final Context ctx;
    private final PanelCommandExecutor commandExecutor;
    private final SoundHandler soundPlayer;
    private final PreLoadCommands preloader;
    private final OpenRequirements requirementsValidator;

    public OpenPanel(Context ctx) {
        this.ctx = ctx;
        this.permission = new PermissionValidator(ctx);
        this.commandExecutor = new PanelCommandExecutor(ctx);
        this.soundPlayer = new SoundHandler(ctx);
        this.preloader = new PreLoadCommands(ctx);
        this.requirementsValidator = new OpenRequirements(ctx);
    }

    public void open(CommandSender sender, Player p, Panel panel, PanelPosition position) {
        boolean openForOtherUser;
        if (p == null) {
            sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Player not found."));
            return;
        }
        if (p.isSleeping()) {
            return;
        }
        if ((this.ctx.debug.isEnabled(sender) || this.ctx.configHandler.isTrue("config.auto-update-panels")) && panel.getFile() != null) {
            panel.setConfig((ConfigurationSection)YamlConfiguration.loadConfiguration((File)panel.getFile()));
        }
        boolean bl = openForOtherUser = !(sender instanceof Player) || sender != p;
        if (!this.permission.hasPermission(sender, p, panel, position, openForOtherUser)) {
            return;
        }
        if (!this.requirementsValidator.canOpenPanel(panel, p)) {
            sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "No permission."));
            return;
        }
        if (position != PanelPosition.Top && !this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Cannot open a panel without a panel at the top already."));
            return;
        }
        if (!this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top) && p.getOpenInventory().getType() != InventoryType.CRAFTING) {
            p.closeInventory();
        }
        PanelOpenedEvent openedEvent = new PanelOpenedEvent(p, panel, position);
        Bukkit.getPluginManager().callEvent((Event)openedEvent);
        if (openedEvent.isCancelled()) {
            return;
        }
        this.preloader.executePreLoad(panel, position, p);
        try {
            new PanelBuilder(this.ctx).openInv(panel, p, position, 0);
            this.commandExecutor.executeOpenCommands(panel, position, p);
            this.soundPlayer.playOpenSound(panel, p);
            if (openForOtherUser) {
                sender.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.GREEN + "Panel Opened for " + p.getDisplayName()));
            }
        }
        catch (Exception r) {
            this.ctx.debug.send(r, null, this.ctx);
            sender.sendMessage(this.ctx.text.colour(this.ctx.tag + this.ctx.configHandler.config.getString("config.format.error")));
            this.ctx.openPanels.closePanelForLoader(p.getName(), position);
            p.closeInventory();
        }
    }
}

