/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.items.name;

import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.items.name.ItemMetaUtil;
import me.rockyhawk.commandpanels.items.name.LoreFormatter;
import me.rockyhawk.commandpanels.items.name.TooltipUtil;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NameHandler {
    private final Context ctx;
    private final ItemMetaUtil itemMetaUtil;
    private final TooltipUtil tooltipUtil;
    private final LoreFormatter loreFormatter;

    public NameHandler(Context ctx) {
        this.ctx = ctx;
        this.itemMetaUtil = new ItemMetaUtil(ctx);
        this.tooltipUtil = new TooltipUtil(ctx);
        this.loreFormatter = new LoreFormatter(ctx);
    }

    public ItemStack setName(Panel panel, ItemStack item, ConfigurationSection section, Player player) {
        boolean hideAttributes = false;
        boolean hideTooltip = false;
        if (section.contains("itemType")) {
            if (section.getStringList("itemType").contains("noAttributes")) {
                hideAttributes = true;
            }
            if (section.getStringList("itemType").contains("hideTooltip")) {
                hideTooltip = true;
            }
        }
        String name = section.getString("name");
        List lore = section.getStringList("lore");
        try {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            name = this.ctx.text.placeholders(panel, PanelPosition.Top, player, name);
            if (hideAttributes) {
                this.itemMetaUtil.hideAttributes(meta);
            }
            if (hideTooltip) {
                this.tooltipUtil.hideTooltip(meta);
            }
            if (name != null) {
                meta.setDisplayName(name);
            }
            if (!lore.isEmpty()) {
                List<String> formattedLore = this.loreFormatter.format(panel, lore, player);
                meta.setLore(this.loreFormatter.splitListWithEscape(formattedLore));
            }
            item.setItemMeta(meta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return item;
    }
}

