/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.items.builder.itemcomponents;

import java.util.HashMap;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.items.builder.ItemComponent;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class LeatherArmorComponent
implements ItemComponent {
    private final Map<String, Color> colourCodes = new HashMap<String, Color>(){
        {
            this.put("AQUA", Color.AQUA);
            this.put("BLUE", Color.BLUE);
            this.put("GRAY", Color.GRAY);
            this.put("GREEN", Color.GREEN);
            this.put("RED", Color.RED);
            this.put("WHITE", Color.WHITE);
            this.put("BLACK", Color.BLACK);
            this.put("FUCHSIA", Color.FUCHSIA);
            this.put("LIME", Color.LIME);
            this.put("MAROON", Color.MAROON);
            this.put("NAVY", Color.NAVY);
            this.put("OLIVE", Color.OLIVE);
            this.put("ORANGE", Color.ORANGE);
            this.put("PURPLE", Color.PURPLE);
            this.put("SILVER", Color.SILVER);
            this.put("TEAL", Color.TEAL);
            this.put("YELLOW", Color.YELLOW);
        }
    };

    @Override
    public ItemStack apply(ItemStack item, ConfigurationSection section, Context ctx, Player player, Panel panel, PanelPosition pos, boolean addNBT) {
        if (!section.contains("leatherarmor")) {
            return item;
        }
        if (item.getType() == Material.LEATHER_BOOTS || item.getType() == Material.LEATHER_LEGGINGS || item.getType() == Material.LEATHER_CHESTPLATE || item.getType() == Material.LEATHER_HELMET || item.getType() == Material.matchMaterial((String)"LEATHER_HORSE_ARMOR")) {
            LeatherArmorMeta leatherMeta = (LeatherArmorMeta)item.getItemMeta();
            String colourCode = ctx.text.placeholdersNoColour(panel, pos, player, section.getString("leatherarmor"));
            assert (colourCode != null);
            if (!colourCode.contains(",")) {
                assert (leatherMeta != null);
                leatherMeta.setColor(this.colourCodes.get(colourCode.toUpperCase()));
            } else {
                int[] colorRGB = new int[]{255, 255, 255};
                int count = 0;
                for (String colourNum : colourCode.split(",")) {
                    colorRGB[count] = Integer.parseInt(colourNum);
                    ++count;
                }
                assert (leatherMeta != null);
                leatherMeta.setColor(Color.fromRGB((int)colorRGB[0], (int)colorRGB[1], (int)colorRGB[2]));
            }
            item.setItemMeta((ItemMeta)leatherMeta);
        }
        return item;
    }
}

