/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.items.builder;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.items.builder.ItemComponent;
import me.rockyhawk.commandpanels.items.builder.MaterialComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.BannerComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.CustomDataComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.DamageComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.EnchantedComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.ItemModelComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.LeatherArmorComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.NBTComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.PotionColorComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.PotionComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.RefreshCommandsComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.StackComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.TooltipComponent;
import me.rockyhawk.commandpanels.items.builder.itemcomponents.TrimComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.BookComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.CPIComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.CPSComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.HeadDatabaseComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.ItemsAdderComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.MMOItemsComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.NexoComponent;
import me.rockyhawk.commandpanels.items.builder.materialcomponents.OraxenComponent;
import me.rockyhawk.commandpanels.items.name.NameHandler;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemBuilder {
    private final Context ctx;
    private final List<MaterialComponent> materialComponents = new ArrayList<MaterialComponent>();
    private final List<ItemComponent> itemComponents = new ArrayList<ItemComponent>();
    private NameHandler name;

    public ItemBuilder(Context ctx) {
        this.ctx = ctx;
        this.name = new NameHandler(ctx);
        this.initialiseComponents();
    }

    public ItemStack buildItem(Panel panel, PanelPosition pos, ConfigurationSection section, Player player, boolean addNBT) {
        String materialTag = this.ctx.text.placeholdersNoColour(panel, pos, player, section.getString("material"));
        if (materialTag == null) {
            return null;
        }
        ItemStack baseItem = null;
        for (MaterialComponent mc : this.materialComponents) {
            if (!mc.matches(materialTag)) continue;
            try {
                baseItem = mc.createItem(materialTag, player, this.ctx, section, panel, pos);
                break;
            }
            catch (Exception e) {
                player.sendMessage(this.ctx.text.colour(this.ctx.tag + this.ctx.configHandler.config.getString("config.format.error") + mc));
            }
        }
        if (baseItem == null) {
            Material mat = Material.matchMaterial((String)materialTag.toUpperCase());
            if (mat == null) {
                return null;
            }
            baseItem = new ItemStack(mat);
        }
        for (ItemComponent ic : this.itemComponents) {
            try {
                baseItem = ic.apply(baseItem, section, this.ctx, player, panel, pos, addNBT);
            }
            catch (Exception e) {
                player.sendMessage(this.ctx.text.colour(this.ctx.tag + this.ctx.configHandler.config.getString("config.format.error") + ic));
            }
        }
        baseItem = this.name.setName(panel, baseItem, section, player);
        return baseItem;
    }

    private void initialiseComponents() {
        this.materialComponents.add(new CPSComponent());
        this.materialComponents.add(new NexoComponent());
        this.materialComponents.add(new OraxenComponent());
        this.materialComponents.add(new ItemsAdderComponent());
        this.materialComponents.add(new MMOItemsComponent());
        this.materialComponents.add(new HeadDatabaseComponent());
        this.materialComponents.add(new CPIComponent());
        this.materialComponents.add(new BookComponent());
        this.itemComponents.add(new NBTComponent());
        this.itemComponents.add(new EnchantedComponent());
        this.itemComponents.add(new ItemModelComponent());
        this.itemComponents.add(new TooltipComponent());
        this.itemComponents.add(new CustomDataComponent());
        this.itemComponents.add(new BannerComponent());
        this.itemComponents.add(new LeatherArmorComponent());
        this.itemComponents.add(new PotionComponent());
        this.itemComponents.add(new PotionColorComponent());
        this.itemComponents.add(new DamageComponent());
        this.itemComponents.add(new TrimComponent());
        this.itemComponents.add(new StackComponent());
        this.itemComponents.add(new RefreshCommandsComponent());
    }
}

