/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.items;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeMap;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class HasSections {
    Context ctx;

    public HasSections(Context pl) {
        this.ctx = pl;
    }

    public String hasSection(Panel panel, PanelPosition position, ConfigurationSection cf, Player p) {
        TreeMap<Integer, String> sortedSections = new TreeMap<Integer, String>();
        for (String key : cf.getKeys(false)) {
            if (!cf.isConfigurationSection(key) || !key.startsWith("has")) continue;
            try {
                int number = Integer.parseInt(key.substring(3));
                sortedSections.put(number, key);
            }
            catch (NumberFormatException number) {}
        }
        for (String hasSection : sortedSections.values()) {
            if (!cf.isConfigurationSection(hasSection)) continue;
            ConfigurationSection currentSection = cf.getConfigurationSection(hasSection);
            int numberOfConditions = currentSection.getKeys(false).size();
            Boolean currentBlockResult = null;
            String previousOperator = "AND";
            for (int a = 0; a < numberOfConditions; ++a) {
                if (!currentSection.isSet("value" + a) || !currentSection.isSet("compare" + a)) continue;
                String value = ChatColor.stripColor((String)this.ctx.text.placeholders(panel, position, p, currentSection.getString("value" + a)));
                String compare = ChatColor.stripColor((String)this.ctx.text.placeholders(panel, position, p, currentSection.getString("compare" + a)));
                String operator = "AND";
                if (compare.endsWith(" OR")) {
                    compare = compare.substring(0, compare.length() - 3);
                    operator = "OR";
                } else if (compare.endsWith(" AND")) {
                    compare = compare.substring(0, compare.length() - 4);
                }
                HashSet<String> values = this.doOperators(new HashSet<String>(Collections.singletonList(value)));
                boolean localResult = false;
                for (String val : values) {
                    if (!this.hasProcess(val, compare)) continue;
                    localResult = true;
                    break;
                }
                if (currentBlockResult == null) {
                    currentBlockResult = localResult;
                } else if (previousOperator.equals("AND")) {
                    currentBlockResult = currentBlockResult != false && localResult;
                } else if (previousOperator.equals("OR")) {
                    currentBlockResult = currentBlockResult != false || localResult;
                }
                previousOperator = operator;
            }
            if (currentBlockResult == null || !currentBlockResult.booleanValue()) continue;
            return "." + hasSection + this.hasSection(panel, position, currentSection, p);
        }
        return "";
    }

    private HashSet<String> doOperators(HashSet<String> value) {
        for (String val : value) {
            if (!val.contains(" OR ")) continue;
            value.remove(val);
            value.addAll(Arrays.asList(val.split(" OR ")));
            return this.doOperators(value);
        }
        return value;
    }

    private boolean hasProcess(String value, String compare) {
        boolean outputValue = true;
        if (value.startsWith("NOT ")) {
            value = value.substring(4);
            outputValue = false;
        }
        if (value.endsWith(" HASPERM")) {
            String playername = value.substring(0, value.length() - 8);
            Player player = Bukkit.getPlayerExact((String)playername);
            if (player != null) {
                return player.hasPermission(compare) == outputValue;
            }
        } else {
            if (value.endsWith(" ISGREATER")) {
                String numericPart = value.replaceAll("[^0-9.\\-]", "");
                BigDecimal target = new BigDecimal(numericPart.replace(",", ""));
                return new BigDecimal(compare).compareTo(target) <= 0 == outputValue;
            }
            return compare.equals(value) == outputValue;
        }
        return false;
    }
}

