/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.inventory;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.events.PanelOpenedEvent;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;

public class InventorySaver
implements Listener {
    public YamlConfiguration inventoryConfig;
    Context ctx;

    public InventorySaver(Context pl) {
        this.ctx = pl;
    }

    public void saveInventoryFile() {
        try {
            this.inventoryConfig.save(this.ctx.plugin.getDataFolder() + File.separator + "inventories.yml");
        }
        catch (IOException s) {
            this.ctx.debug.send(s, null, this.ctx);
        }
    }

    @EventHandler
    public void onOpen(PanelOpenedEvent e) {
        if (e.getPosition() != PanelPosition.Top) {
            this.addInventory(e.getPlayer());
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (this.inventoryConfig.contains(e.getPlayer().getUniqueId().toString())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDeath(PlayerDeathEvent e) {
        if (this.ctx.openPanels.hasPanelOpen(e.getEntity().getName(), PanelPosition.Middle) || this.ctx.openPanels.hasPanelOpen(e.getEntity().getName(), PanelPosition.Bottom)) {
            if (e.getKeepInventory()) {
                return;
            }
            e.getDrops().clear();
            ItemStack[] inventoryItems = this.ctx.inventorySaver.getNormalInventory(e.getEntity());
            List nonNullItems = Arrays.stream(inventoryItems).filter(Objects::nonNull).collect(Collectors.toList());
            e.getDrops().addAll(nonNullItems);
        }
    }

    @EventHandler
    public void playerJoined(PlayerJoinEvent e) {
        this.restoreInventory(e.getPlayer(), PanelPosition.Top);
    }

    public void restoreInventory(Player p, PanelPosition position) {
        if (p == null) {
            return;
        }
        if (this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Middle) || this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Bottom)) {
            if (position == PanelPosition.Bottom) {
                for (int s = 0; s < 9; ++s) {
                    p.getInventory().setItem(s, null);
                }
            } else if (position == PanelPosition.Middle) {
                for (int s = 9; s < 36; ++s) {
                    p.getInventory().setItem(s, null);
                }
            }
            return;
        }
        if (this.inventoryConfig.isSet(p.getUniqueId().toString())) {
            p.getInventory().setContents(this.ctx.itemSerializer.itemStackArrayFromBase64(this.inventoryConfig.getString(p.getUniqueId().toString())));
            this.inventoryConfig.set(p.getUniqueId().toString(), null);
        }
    }

    public void addInventory(Player p) {
        if (!this.inventoryConfig.contains(p.getUniqueId().toString())) {
            this.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.ctx.itemSerializer.itemStackArrayToBase64(p.getInventory().getContents()));
            ItemStack[] armorContents = (ItemStack[])p.getInventory().getArmorContents().clone();
            p.getInventory().clear();
            p.getInventory().setArmorContents(armorContents);
        }
    }

    public ItemStack[] getNormalInventory(Player p) {
        if (this.hasNormalInventory(p)) {
            return p.getInventory().getContents();
        }
        return this.ctx.itemSerializer.itemStackArrayFromBase64(this.inventoryConfig.getString(p.getUniqueId().toString()));
    }

    public boolean hasNormalInventory(Player p) {
        return !this.inventoryConfig.isSet(p.getUniqueId().toString());
    }

    public void addItem(Player p, ItemStack item) {
        if (this.hasNormalInventory(p)) {
            if (p.getInventory().firstEmpty() >= 0) {
                p.getInventory().addItem(new ItemStack[]{item});
                return;
            }
        } else {
            ArrayList<ItemStack> cont = new ArrayList<ItemStack>(Arrays.asList(this.getNormalInventory(p)));
            boolean found = false;
            for (int i = 0; 36 > i; ++i) {
                if (cont.get(i) == null) {
                    cont.set(i, item);
                    found = true;
                    break;
                }
                if (((ItemStack)cont.get(i)).getAmount() >= ((ItemStack)cont.get(i)).getMaxStackSize() || !((ItemStack)cont.get(i)).isSimilar(item)) continue;
                ((ItemStack)cont.get(i)).setAmount(((ItemStack)cont.get(i)).getAmount() + item.getAmount());
                found = true;
                break;
            }
            if (found) {
                this.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.ctx.itemSerializer.itemStackArrayToBase64(cont.toArray(new ItemStack[0])));
                return;
            }
        }
        p.getLocation().getWorld().dropItemNaturally(p.getLocation(), item);
    }
}

