/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.tags;

import java.util.Arrays;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interaction.commands.TagResolver;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TeleportTag
implements TagResolver {
    @Override
    public boolean handle(Context ctx, Panel panel, PanelPosition pos, Player player, String command) {
        if (!command.startsWith("teleport=")) {
            return false;
        }
        String[] args = ctx.text.attachPlaceholders(panel, pos, player, command).split("\\s+");
        args = Arrays.copyOfRange(args, 1, args.length);
        float yaw = 0.0f;
        float pitch = 0.0f;
        Player teleportedPlayer = player;
        World teleportedWorld = player.getWorld();
        try {
            float x = Float.parseFloat(args[0]);
            float y = Float.parseFloat(args[1]);
            float z = Float.parseFloat(args[2]);
            for (String val : args) {
                if (val.startsWith("world:")) {
                    teleportedWorld = Bukkit.getWorld((String)val.substring(6));
                    continue;
                }
                if (val.startsWith("yaw:")) {
                    yaw = Float.parseFloat(val.substring(4));
                    continue;
                }
                if (val.startsWith("pitch:")) {
                    pitch = Float.parseFloat(val.substring(6));
                    continue;
                }
                if (!val.startsWith("player:")) continue;
                teleportedPlayer = Bukkit.getPlayer((String)val.substring(7));
            }
            Location teleportLocation = new Location(teleportedWorld, (double)x, (double)y, (double)z, yaw, pitch);
            if (teleportedPlayer == player) {
                teleportedPlayer.teleport(teleportLocation);
            } else {
                teleportedPlayer.teleport(teleportLocation);
            }
            return true;
        }
        catch (Exception ex) {
            ctx.debug.send(ex, player, ctx);
            return false;
        }
    }
}

