/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.tags;

import java.lang.reflect.Method;
import java.util.Arrays;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interaction.commands.TagResolver;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SkriptTag
implements TagResolver {
    @Override
    public boolean handle(Context ctx, Panel panel, PanelPosition pos, Player player, String command) {
        if (!command.startsWith("skript=")) {
            return false;
        }
        String[] args = ctx.text.attachPlaceholders(panel, pos, player, command).split("\\s+");
        if ((args = Arrays.copyOfRange(args, 1, args.length)).length == 0) {
            player.sendMessage(ctx.tag + ctx.text.colour(ctx.configHandler.config.getString("config.format.error") + " skript=: No Skript command provided!"));
            return true;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("Skript")) {
            player.sendMessage(ctx.tag + ctx.text.colour(ctx.configHandler.config.getString("config.format.error") + " skript=: Skript plugin is not loaded!"));
            return true;
        }
        try {
            String commandName = args[0];
            String[] commandArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
            this.executeSkriptCommand(ctx, player, commandName, commandArgs);
        }
        catch (Exception ex) {
            player.sendMessage(ctx.tag + ctx.text.colour(ctx.configHandler.config.getString("config.format.error") + " skript=: Error executing Skript command!"));
            ctx.debug.send(ex, player, ctx);
        }
        return true;
    }

    private void executeSkriptCommand(Context ctx, Player player, String commandName, String[] args) {
        try {
            Class<?> commandsClass = Class.forName("ch.njol.skript.command.Commands");
            Class<?> scriptCommandClass = Class.forName("ch.njol.skript.command.ScriptCommand");
            Method getCommandsMethod = commandsClass.getMethod("getCommands", new Class[0]);
            Object commands = getCommandsMethod.invoke(null, new Object[0]);
            if (commands instanceof Iterable) {
                Iterable commandList = (Iterable)commands;
                for (Object command : commandList) {
                    Method getNameMethod;
                    String scriptCommandName;
                    if (!command.getClass().equals(scriptCommandClass) || !(scriptCommandName = (String)(getNameMethod = command.getClass().getMethod("getName", new Class[0])).invoke(command, new Object[0])).equalsIgnoreCase(commandName)) continue;
                    Method executeMethod = command.getClass().getMethod("execute", Player.class, String.class, String[].class);
                    executeMethod.invoke(command, player, commandName, args);
                    return;
                }
            }
            player.sendMessage("Command '" + commandName + "' not found in Skript!");
        }
        catch (Exception e) {
            try {
                this.executeSkriptFunction(commandName, new Object[]{player});
            }
            catch (Exception ex) {
                String fullCommand = args.length > 0 ? commandName + " " + String.join((CharSequence)" ", args) : commandName;
                ctx.scheduler.runTask(() -> Bukkit.dispatchCommand((CommandSender)player, (String)fullCommand));
            }
        }
    }

    private void executeSkriptFunction(String functionName, Object[] params) throws Exception {
        Class<?> functionsClass = Class.forName("ch.njol.skript.lang.function.Functions");
        Class<?> functionClass = Class.forName("ch.njol.skript.lang.function.Function");
        Method getFunctionMethod = functionsClass.getMethod("getFunction", String.class);
        Object function = getFunctionMethod.invoke(null, functionName);
        if (function != null) {
            Method executeMethod = functionClass.getMethod("execute", Object[].class);
            executeMethod.invoke(function, new Object[]{params});
        }
    }
}

