/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.paywalls.itempaywall;

import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interaction.commands.PaywallOutput;
import me.rockyhawk.commandpanels.interaction.commands.PaywallResolver;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.itempaywall.ItemRemovalHandler;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.itempaywall.ItemValidator;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemPaywall
implements PaywallResolver {
    private final ItemRemovalHandler itemRemovalHandler = new ItemRemovalHandler();

    @Override
    public PaywallOutput handle(Context ctx, Panel panel, PanelPosition pos, Player player, String command, boolean performOperation) {
        if (!command.toLowerCase().startsWith("item-paywall=")) {
            return PaywallOutput.NotApplicable;
        }
        try {
            String[] args = ctx.text.attachPlaceholders(panel, pos, player, command.substring("item-paywall=".length()).trim()).split(" ");
            if (args.length < 2) {
                ctx.text.sendString(player, ctx.tag + "Invalid item-paywall usage. Not enough arguments.");
                return PaywallOutput.Blocked;
            }
            boolean ignoreNBT = false;
            for (String val : args) {
                if (!val.equals("IGNORENBT")) continue;
                ignoreNBT = true;
                break;
            }
            ItemValidator itemValidator = new ItemValidator(ctx);
            ItemStack sellItem = itemValidator.createItemFromArgs(args, panel, pos, player);
            PaywallOutput removedItem = PaywallOutput.Blocked;
            if (this.itemRemovalHandler.removeItem(ctx, player, sellItem, ignoreNBT, performOperation)) {
                removedItem = PaywallOutput.Passed;
            }
            if (removedItem == PaywallOutput.Blocked) {
                if (ctx.configHandler.isTrue("purchase.item.enable")) {
                    ctx.text.sendString(panel, pos, player, Objects.requireNonNull(ctx.configHandler.config.getString("purchase.item.failure")));
                }
            } else if (ctx.configHandler.isTrue("purchase.item.enable") && performOperation) {
                ctx.text.sendString(panel, pos, player, Objects.requireNonNull(ctx.configHandler.config.getString("purchase.item.success")).replaceAll("%cp-args%", args[0]));
            }
            return removedItem;
        }
        catch (Exception e) {
            ctx.debug.send(e, player, ctx);
            ctx.text.sendString(player, ctx.tag + ctx.configHandler.config.getString("config.format.error") + " command: item-paywall");
            return PaywallOutput.Blocked;
        }
    }
}

