/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.paywalls;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interaction.commands.PaywallOutput;
import me.rockyhawk.commandpanels.interaction.commands.PaywallResolver;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.entity.Player;

public class XpPaywall
implements PaywallResolver {
    @Override
    public PaywallOutput handle(Context ctx, Panel panel, PanelPosition pos, Player player, String command, boolean performOperation) {
        if (!command.toLowerCase().startsWith("xp-paywall=")) {
            return PaywallOutput.NotApplicable;
        }
        String[] args = ctx.text.attachPlaceholders(panel, pos, player, command.substring("xp-paywall=".length()).trim()).split(" ");
        if (args.length < 2) {
            ctx.text.sendString(player, ctx.tag + "Invalid xp-paywall usage. Not enough arguments.");
            return PaywallOutput.Blocked;
        }
        try {
            String failureMsg;
            int balance = 0;
            balance = args[1].startsWith("level") ? player.getLevel() : this.getPlayerExp(player);
            int requiredAmount = Integer.parseInt(args[0]);
            if (balance >= requiredAmount) {
                String successMsg;
                if (args[1].startsWith("level")) {
                    if (performOperation) {
                        player.setLevel(player.getLevel() - requiredAmount);
                    }
                } else if (performOperation) {
                    this.removePlayerExp(player, requiredAmount);
                }
                if (ctx.configHandler.isTrue("purchase.xp.enable") && performOperation && (successMsg = ctx.configHandler.config.getString("purchase.xp.success")) != null) {
                    ctx.text.sendString(panel, PanelPosition.Top, player, successMsg.replaceAll("%cp-args%", args[0]));
                }
                return PaywallOutput.Passed;
            }
            if (ctx.configHandler.isTrue("purchase.xp.enable") && (failureMsg = ctx.configHandler.config.getString("purchase.xp.failure")) != null) {
                ctx.text.sendString(panel, PanelPosition.Top, player, failureMsg);
            }
            return PaywallOutput.Blocked;
        }
        catch (Exception ex) {
            ctx.debug.send(ex, player, ctx);
            ctx.text.sendString(player, ctx.tag + ctx.configHandler.config.getString("config.format.error") + " command: xp-paywall");
            return PaywallOutput.Blocked;
        }
    }

    private int getExpAtLevel(int level) {
        if (level <= 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level <= 31) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    private int getExpToLevelUp(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    private int getPlayerExp(Player player) {
        int exp = 0;
        int level = player.getLevel();
        exp += this.getExpAtLevel(level);
        return exp += Math.round((float)this.getExpToLevelUp(level) * player.getExp());
    }

    private int removePlayerExp(Player player, int exp) {
        int currentExp = this.getPlayerExp(player);
        player.setExp(0.0f);
        player.setLevel(0);
        int newExp = currentExp - exp;
        player.giveExp(newExp);
        return newExp;
    }
}

