/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands.paywalls;

import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interaction.commands.PaywallOutput;
import me.rockyhawk.commandpanels.interaction.commands.PaywallResolver;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.entity.Player;

public class DataPaywall
implements PaywallResolver {
    @Override
    public PaywallOutput handle(Context ctx, Panel panel, PanelPosition pos, Player player, String command, boolean performOperation) {
        if (!command.toLowerCase().startsWith("data-paywall=")) {
            return PaywallOutput.NotApplicable;
        }
        String[] args = ctx.text.attachPlaceholders(panel, pos, player, command.substring("data-paywall=".length()).trim()).split(" ");
        if (args.length < 2) {
            ctx.text.sendString(player, ctx.tag + "Invalid data-paywall usage. Not enough arguments.");
            return PaywallOutput.Blocked;
        }
        try {
            String failureMsg;
            String dataKey = args[0];
            String amountStr = args[1];
            double requiredAmount = Double.parseDouble(amountStr);
            double currentAmount = Double.parseDouble(ctx.panelData.getUserData(player.getName(), dataKey));
            if (currentAmount >= requiredAmount) {
                String successMsg;
                if (performOperation) {
                    ctx.panelData.doDataMath(player.getName(), dataKey, "-" + ctx.text.placeholdersNoColour(panel, PanelPosition.Top, player, amountStr));
                }
                if (ctx.configHandler.isTrue("purchase.data.enable") && (successMsg = ctx.configHandler.config.getString("purchase.data.success")) != null) {
                    ctx.text.sendString(panel, PanelPosition.Top, player, successMsg.replace("%cp-args%", dataKey));
                }
                return PaywallOutput.Passed;
            }
            if (ctx.configHandler.isTrue("purchase.data.enable") && (failureMsg = ctx.configHandler.config.getString("purchase.data.failure")) != null) {
                ctx.text.sendString(panel, PanelPosition.Top, player, failureMsg);
            }
            return PaywallOutput.Blocked;
        }
        catch (Exception ex) {
            ctx.debug.send(ex, player, ctx);
            ctx.text.sendString(player, ctx.tag + ctx.configHandler.config.getString("config.format.error") + " command: data-paywall");
            return PaywallOutput.Blocked;
        }
    }
}

