/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.commands;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interaction.commands.PaywallOutput;
import me.rockyhawk.commandpanels.interaction.commands.PaywallResolver;
import me.rockyhawk.commandpanels.interaction.commands.TagResolver;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.DataPaywall;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.HasPerm;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.Paywall;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.TokenPaywall;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.XpPaywall;
import me.rockyhawk.commandpanels.interaction.commands.paywalls.itempaywall.ItemPaywall;
import me.rockyhawk.commandpanels.interaction.commands.tags.AddPlaceholderTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.BasicTags;
import me.rockyhawk.commandpanels.interaction.commands.tags.BungeeTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.ClosePanelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.CloseTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataAddTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataClearTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataDelTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataMathTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DataSetTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.DelayTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.EnchantTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.EvalDelayTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.GiveItemTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.MiniMessageTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.OpenTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.PlaceholderTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.RefreshTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SetCustomDataTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SetItemTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SkriptTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.SoundTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.TeleportTag;
import me.rockyhawk.commandpanels.interaction.commands.tags.TitleTag;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class CommandRunner {
    private final Context ctx;
    private final List<PaywallResolver> paywalls = new ArrayList<PaywallResolver>();
    private final List<TagResolver> tags = new ArrayList<TagResolver>();

    public CommandRunner(Context ctx) {
        this.ctx = ctx;
        this.registerBuiltInTags();
    }

    public void runCommands(Panel panel, PanelPosition position, Player p, List<String> commands, ClickType click) {
        for (String command : commands) {
            if (click != null && (command = this.hasCorrectClick(command, click)).equals("")) continue;
            PaywallOutput output = this.runPaywalls(panel, position, p, command, true);
            if (output == PaywallOutput.Blocked) break;
            if (output != PaywallOutput.NotApplicable) continue;
            this.runCommand(panel, position, p, command);
        }
    }

    public void runCommand(Panel panel, PanelPosition position, Player p, String commandRaw) {
        for (TagResolver tag : this.tags) {
            if (!tag.handle(this.ctx, panel, position, p, commandRaw)) continue;
            return;
        }
        String finalCommand = this.ctx.text.attachPlaceholders(panel, position, p, commandRaw.trim());
        this.ctx.scheduler.runTask(() -> Bukkit.dispatchCommand((CommandSender)p, (String)finalCommand));
    }

    public boolean runMultiPaywall(Panel panel, PanelPosition position, Player p, List<String> paywalls, List<String> commands, ClickType click) {
        ArrayList<String> allCommands = new ArrayList<String>(paywalls);
        allCommands.addAll(commands);
        for (String command : allCommands) {
            if (this.runPaywalls(panel, position, p, command, false) != PaywallOutput.Blocked) continue;
            return false;
        }
        this.runCommands(panel, position, p, allCommands, click);
        return true;
    }

    public void addTag(TagResolver tag) {
        this.tags.add(tag);
    }

    public void addPaywall(PaywallResolver paywall) {
        this.paywalls.add(paywall);
    }

    private void registerBuiltInTags() {
        this.paywalls.add(new Paywall());
        this.paywalls.add(new TokenPaywall());
        this.paywalls.add(new ItemPaywall());
        this.paywalls.add(new HasPerm());
        this.paywalls.add(new XpPaywall());
        this.paywalls.add(new DataPaywall());
        this.tags.add(new AddPlaceholderTag());
        this.tags.add(new BasicTags());
        this.tags.add(new BungeeTag());
        this.tags.add(new ClosePanelTag());
        this.tags.add(new CloseTag());
        this.tags.add(new DataAddTag());
        this.tags.add(new DataClearTag());
        this.tags.add(new DataDelTag());
        this.tags.add(new DataMathTag());
        this.tags.add(new DataSetTag());
        this.tags.add(new DelayTag());
        this.tags.add(new EnchantTag());
        this.tags.add(new EvalDelayTag());
        this.tags.add(new GiveItemTag());
        try {
            Class.forName("net.kyori.adventure.text.Component");
            Class.forName("net.kyori.adventure.text.format.TextDecoration");
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
            Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
            this.tags.add(new MiniMessageTag());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.tags.add(new OpenTag());
        this.tags.add(new PlaceholderTag());
        this.tags.add(new RefreshTag());
        this.tags.add(new SetCustomDataTag());
        this.tags.add(new SetItemTag());
        this.tags.add(new SkriptTag());
        this.tags.add(new SoundTag());
        this.tags.add(new TeleportTag());
        this.tags.add(new TitleTag());
    }

    private PaywallOutput runPaywalls(Panel panel, PanelPosition position, Player p, String command, boolean performOperation) {
        for (PaywallResolver paywall : this.paywalls) {
            PaywallOutput result = paywall.handle(this.ctx, panel, position, p, command, performOperation);
            if (result == PaywallOutput.NotApplicable) continue;
            return result;
        }
        return PaywallOutput.NotApplicable;
    }

    public String hasCorrectClick(String command, ClickType click) {
        try {
            String[] parts = command.split("\\s", 2);
            String prefix = parts[0];
            String rest = parts.length > 1 ? parts[1] : "";
            switch (prefix) {
                case "right=": {
                    return click == ClickType.RIGHT ? rest : "";
                }
                case "rightshift=": {
                    return click == ClickType.SHIFT_RIGHT ? rest : "";
                }
                case "left=": {
                    return click == ClickType.LEFT ? rest : "";
                }
                case "leftshift=": {
                    return click == ClickType.SHIFT_LEFT ? rest : "";
                }
                case "middle=": {
                    return click == ClickType.MIDDLE ? rest : "";
                }
            }
            return command;
        }
        catch (Exception e) {
            return "";
        }
    }
}

