/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.click;

import java.util.List;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.events.PanelInteractionEvent;
import me.rockyhawk.commandpanels.interaction.click.InteractionHandler;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;

public class OutsideHandler {
    private final InteractionHandler handler;

    protected OutsideHandler(InteractionHandler handler) {
        this.handler = handler;
    }

    protected void handle(InventoryClickEvent e) {
        Panel panel;
        boolean isOutsideClick;
        Player p = (Player)e.getWhoClicked();
        boolean panelOpen = this.handler.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top);
        boolean bl = isOutsideClick = e.getSlotType() == InventoryType.SlotType.OUTSIDE;
        if ((panelOpen || e.getClick() == ClickType.DOUBLE_CLICK) && isOutsideClick && (panel = this.handler.ctx.openPanels.getOpenPanel(p.getName(), PanelPosition.Top)) != null && panel.getConfig().contains("outside-commands")) {
            PanelInteractionEvent interactionEvent = new PanelInteractionEvent(p, e.getSlot(), panel, null);
            Bukkit.getPluginManager().callEvent((Event)interactionEvent);
            if (interactionEvent.isCancelled()) {
                return;
            }
            this.runCommands(panel.getConfig().getStringList("outside-commands"), panel, p, e);
            return;
        }
        if (isOutsideClick && !panelOpen && this.handler.ctx.configHandler.config.contains("config.outside-commands")) {
            this.runCommands(this.handler.ctx.configHandler.config.getStringList("config.outside-commands"), null, p, e);
        }
    }

    private void runCommands(List<String> commands, Panel panel, Player player, InventoryClickEvent e) {
        try {
            this.handler.ctx.commands.runCommands(panel, PanelPosition.Top, player, commands, e.getClick());
        }
        catch (Exception ex) {
            this.handler.ctx.debug.send(ex, player, this.handler.ctx);
        }
    }
}

