/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.interaction.blocks;

import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockEvents
implements Listener {
    Context ctx;

    public BlockEvents(Context pl) {
        this.ctx = pl;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        boolean isPanelBlock;
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && e.getClickedBlock() != null && (isPanelBlock = this.blockClickEventTrigger(e.getClickedBlock().getLocation(), e.getPlayer(), true))) {
            this.blockClickEventTrigger(e.getClickedBlock().getLocation(), e.getPlayer(), false);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        boolean isPanelBlock = this.blockClickEventTrigger(e.getRightClicked().getLocation().getBlock().getLocation(), e.getPlayer(), true);
        if (isPanelBlock && !e.getPlayer().isSneaking()) {
            this.blockClickEventTrigger(e.getRightClicked().getLocation().getBlock().getLocation(), e.getPlayer(), false);
            e.setCancelled(true);
        }
    }

    public boolean blockClickEventTrigger(Location location, Player p, boolean isVoid) {
        if (!this.ctx.configHandler.isTrue("config.panel-blocks")) {
            return false;
        }
        if (!this.ctx.configHandler.blockConfig.contains("blocks")) {
            return false;
        }
        if (this.ctx.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return false;
        }
        for (String configLocation : Objects.requireNonNull(this.ctx.configHandler.blockConfig.getConfigurationSection("blocks")).getKeys(false)) {
            String[] loc = configLocation.split("_");
            Location tempLocation = new Location(this.ctx.plugin.getServer().getWorld(loc[0].replaceAll("%dash%", "_")), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]), Double.parseDouble(loc[3]));
            if (!tempLocation.equals((Object)location)) continue;
            if (this.ctx.configHandler.blockConfig.contains("blocks." + configLocation + ".commands")) {
                if (!isVoid) {
                    for (String command : this.ctx.configHandler.blockConfig.getStringList("blocks." + configLocation + ".commands")) {
                        this.ctx.commands.runCommand(null, PanelPosition.Top, p, command);
                    }
                }
                return true;
            }
            if (!isVoid) {
                String command = "open= " + this.ctx.configHandler.blockConfig.getString("blocks." + configLocation + ".panel");
                this.ctx.commands.runCommand(null, PanelPosition.Top, p, command);
            }
            return true;
        }
        return false;
    }
}

