/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.generate.deluxecompatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.rockyhawk.commandpanels.Context;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class CompatibilityConverter {
    Context ctx;

    public CompatibilityConverter(Context pl) {
        this.ctx = pl;
    }

    public YamlConfiguration tryConversion(String fileName, YamlConfiguration inputYaml) {
        try {
            YamlConfiguration convertedYaml = new YamlConfiguration();
            ConfigurationSection panelsSection = convertedYaml.createSection("panels");
            ArrayList<String> allRequirementDetails = new ArrayList<String>();
            if (inputYaml.contains("menus")) {
                ConfigurationSection menusSection = inputYaml.getConfigurationSection("menus");
                for (String menuName : menusSection.getKeys(false)) {
                    ConfigurationSection menuData = menusSection.getConfigurationSection(menuName);
                    List<String> requirements = this.convertMenu(menuData, menuName, panelsSection);
                    allRequirementDetails.addAll(requirements);
                }
            } else {
                List<String> requirements = this.convertMenu((ConfigurationSection)inputYaml, ChatColor.stripColor((String)this.ctx.text.colour(inputYaml.getString("menu_title"))), panelsSection);
                allRequirementDetails.addAll(requirements);
            }
            return convertedYaml;
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Error in file: " + fileName);
            return null;
        }
    }

    private List<String> convertMenu(ConfigurationSection data, String panelName, ConfigurationSection panelsSection) {
        ArrayList<String> allRequirementDetails = new ArrayList<String>();
        try {
            ConfigurationSection panel = panelsSection.createSection(panelName);
            panel.set("title", (Object)data.getString("menu_title", "&8" + panelName));
            panel.set("rows", (Object)((int)Math.ceil((double)data.getInt("size", 9) / 9.0)));
            panel.set("perm", (Object)"default");
            panel.set("empty", (Object)data.getString("empty", "BLACK_STAINED_GLASS_PANE"));
            if (data.contains("open_command")) {
                if (data.isList("open_command")) {
                    panel.set("commands", (Object)data.getStringList("open_command"));
                } else {
                    ArrayList<String> commands = new ArrayList<String>();
                    commands.add(data.getString("open_command"));
                    panel.set("commands", commands);
                }
            }
            if (data.contains("open_commands")) {
                panel.set("commands-on-open", this.checkTags(data.getStringList("open_commands")));
            }
            if (data.contains("close_commands")) {
                panel.set("commands-on-close", this.checkTags(data.getStringList("close_commands")));
            }
            if (data.contains("update_interval")) {
                panel.set("refresh-delay", (Object)(data.getInt("update_interval") * 20));
            }
            ConfigurationSection itemSection = panel.createSection("item");
            if (data.contains("items")) {
                ConfigurationSection itemsData = data.getConfigurationSection("items");
                HashMap items = new HashMap();
                for (String itemKey : itemsData.getKeys(false)) {
                    ConfigurationSection clickReqSection;
                    ConfigurationSection viewReqSection;
                    ConfigurationSection itemData = itemsData.getConfigurationSection(itemKey);
                    if (!itemData.contains("slot")) continue;
                    int slot = itemData.getInt("slot");
                    int priority = itemData.getInt("priority", 0);
                    if (!items.containsKey(slot)) {
                        items.put(slot, new HashMap());
                    }
                    HashMap<String, Object> itemProperties = new HashMap<String, Object>();
                    itemProperties.put("material", itemData.getString("material", "STONE"));
                    itemProperties.put("stack", itemData.get("amount", itemData.get("dynamic_amount", (Object)1)));
                    if (itemData.contains("display_name")) {
                        itemProperties.put("name", itemData.getString("display_name"));
                    }
                    if (itemData.contains("lore")) {
                        itemProperties.put("lore", itemData.getStringList("lore"));
                    }
                    if (itemData.contains("enchantments")) {
                        itemProperties.put("enchanted", itemData.get("enchantments"));
                    }
                    if (itemData.contains("model_data")) {
                        itemProperties.put("customdata", itemData.getInt("model_data"));
                    }
                    if (itemData.contains("click_commands")) {
                        itemProperties.put("commands", this.checkTags(itemData.getStringList("click_commands")));
                    }
                    if (itemData.contains("view_requirement") && (viewReqSection = itemData.getConfigurationSection("view_requirement")).contains("requirements")) {
                        List<Map<?, ?>> viewRequirements = this.getRequirementsList(viewReqSection, "requirements");
                        itemProperties.put("view_requirements", viewRequirements);
                    }
                    if (itemData.contains("click_requirement") && (clickReqSection = itemData.getConfigurationSection("click_requirement")).contains("requirements")) {
                        List<Map<?, ?>> clickRequirements = this.getRequirementsList(clickReqSection, "requirements");
                        itemProperties.put("click_requirements", clickRequirements);
                    }
                    ((Map)items.get(slot)).put(priority, itemProperties);
                }
                Iterator<Object> iterator = items.keySet().iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    Map slotItems = (Map)items.get(slot);
                    ArrayList priorities = new ArrayList(slotItems.keySet());
                    priorities.sort((a, b) -> b - a);
                    for (int i = 0; i < priorities.size(); ++i) {
                        int priority = (Integer)priorities.get(i);
                        Map itemProps = (Map)slotItems.get(priority);
                        if (i == 0) {
                            ConfigurationSection slotSection = itemSection.createSection(String.valueOf(slot));
                            slotSection.set("material", itemProps.get("material"));
                            slotSection.set("stack", itemProps.get("stack"));
                            if (itemProps.containsKey("name")) {
                                slotSection.set("name", itemProps.get("name"));
                            }
                            if (itemProps.containsKey("lore")) {
                                slotSection.set("lore", itemProps.get("lore"));
                            }
                            if (itemProps.containsKey("enchanted")) {
                                slotSection.set("enchanted", itemProps.get("enchanted"));
                            }
                            if (itemProps.containsKey("customdata")) {
                                slotSection.set("customdata", itemProps.get("customdata"));
                            }
                            if (!itemProps.containsKey("commands")) continue;
                            slotSection.set("commands", itemProps.get("commands"));
                            continue;
                        }
                        String hasKey = "has" + (i - 1);
                        ConfigurationSection slotSection = itemSection.getConfigurationSection(String.valueOf(slot));
                        ConfigurationSection hasSection = slotSection.createSection(hasKey);
                        hasSection.set("material", itemProps.get("material"));
                        hasSection.set("stack", itemProps.get("stack"));
                        if (itemProps.containsKey("name")) {
                            hasSection.set("name", itemProps.get("name"));
                        }
                        if (itemProps.containsKey("lore")) {
                            hasSection.set("lore", itemProps.get("lore"));
                        }
                        if (itemProps.containsKey("enchanted")) {
                            hasSection.set("enchanted", itemProps.get("enchanted"));
                        }
                        if (itemProps.containsKey("customdata")) {
                            hasSection.set("customdata", itemProps.get("customdata"));
                        }
                        if (itemProps.containsKey("commands")) {
                            hasSection.set("commands", itemProps.get("commands"));
                        }
                        ArrayList mergedRequirements = new ArrayList();
                        if (itemProps.containsKey("view_requirements")) {
                            List viewReqs = (List)itemProps.get("view_requirements");
                            mergedRequirements.addAll(viewReqs);
                        }
                        if (itemProps.containsKey("click_requirements")) {
                            List clickReqs = (List)itemProps.get("click_requirements");
                            mergedRequirements.addAll(clickReqs);
                        }
                        if (mergedRequirements.isEmpty()) continue;
                        this.convertRequirements(mergedRequirements, slotSection, hasKey, allRequirementDetails);
                    }
                }
            }
            return allRequirementDetails;
        }
        catch (Exception e) {
            return allRequirementDetails;
        }
    }

    private List<Map<?, ?>> getRequirementsList(ConfigurationSection section, String key) {
        if (section.isList(key)) {
            return section.getMapList(key);
        }
        return new ArrayList();
    }

    private void convertRequirements(List<Map<?, ?>> requirements, ConfigurationSection panel, String hasSection, List<String> allRequirementDetails) {
        for (Map<?, ?> requirement : requirements) {
            boolean not;
            Map reqDetails;
            Map.Entry<?, ?> entry;
            if (requirement.isEmpty() || !((entry = requirement.entrySet().iterator().next()).getValue() instanceof Map) || !(reqDetails = (Map)entry.getValue()).containsKey("type")) continue;
            String type = reqDetails.get("type").toString();
            String slotStr = panel.getName();
            ConfigurationSection hasKeySection = panel.getConfigurationSection(hasSection);
            if (type.contains("has permission")) {
                String permission = reqDetails.get("permission").toString();
                boolean not2 = type.contains("!");
                hasKeySection.set("value0", (Object)(not2 ? "NOT %cp-player-name% HASPERM" : "%cp-player-name% HASPERM"));
                hasKeySection.set("compare0", (Object)permission);
                allRequirementDetails.add("Slot " + slotStr + ": Requires permission '" + permission + "'");
            }
            if (type.contains("has money")) {
                double amount = Double.parseDouble(reqDetails.get("amount").toString());
                not = type.contains("!");
                hasKeySection.set("value0", (Object)(not ? "NOT %cp-player-balance% ISGREATER" : "%cp-player-balance% ISGREATER"));
                hasKeySection.set("compare0", (Object)amount);
                allRequirementDetails.add("Slot " + slotStr + ": Requires at least $" + amount);
            }
            if (!type.contains("string equals")) continue;
            String input = reqDetails.get("input").toString();
            String output = reqDetails.get("output").toString();
            not = type.contains("!");
            hasKeySection.set("value0", (Object)(not ? "NOT " + input : input));
            hasKeySection.set("compare0", (Object)output);
            allRequirementDetails.add("Slot " + slotStr + ": Requires '" + input + "' to equal '" + output + "'");
        }
    }

    private List<String> checkTags(List<String> commands) {
        ArrayList<String> newCommands = new ArrayList<String>();
        for (String command : commands) {
            int startIndex;
            int endIndex;
            String newCommand = command;
            if (newCommand.contains("<delay=") && (endIndex = newCommand.indexOf(">", startIndex = newCommand.indexOf("<delay=") + 7)) > startIndex) {
                String delayValue = newCommand.substring(startIndex, endIndex);
                newCommand = "delay= " + delayValue + " " + newCommand.substring(0, startIndex - 7).trim();
            }
            newCommand = newCommand.replace("[player]", "").replace("[console]", "console=").replace("[commandevent]", "sudo=").replace("[message]", "msg=").replace("[broadcast]", "broadcast=").replace("[openguimenu]", "open=").replace("[connect]", "server=").replace("[close]", "cpc").replace("[refresh]", "refresh").replace("[sound]", "sound=").replace("[takemoney]", "paywall=").replace("[takeexp]", "xp-paywall=").replace("[chat]", "send=").replace("%player_name%", "%cp-player-name%");
            newCommands.add(newCommand);
        }
        return newCommands;
    }
}

