/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.generate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.generate.GenItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GenUtils
implements Listener {
    public YamlConfiguration tempEdit;
    public List<Player> generateMode = new ArrayList<Player>();
    Context ctx;

    public GenUtils(Context pl) {
        this.ctx = pl;
        this.tempEdit = YamlConfiguration.loadConfiguration((File)new File(this.ctx.plugin.getDataFolder() + File.separator + "temp.yml"));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        if (!p.hasPermission("commandpanel.generate")) {
            return;
        }
        if (!ChatColor.stripColor((String)e.getView().getTitle()).equals("Generate New Panel")) {
            return;
        }
        this.ctx.reloader.reloadPanelFiles();
        this.generatePanel(p, e.getInventory());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.generateMode.remove(p);
    }

    @EventHandler
    public void onInventoryOpenEvent(InventoryOpenEvent e) {
        HumanEntity h = e.getPlayer();
        Player p = Bukkit.getPlayer((String)h.getName());
        if (this.generateMode.contains(p)) {
            this.generateMode.remove(p);
            this.generatePanel(p, e.getInventory());
        }
    }

    private void generatePanel(Player p, Inventory inv) {
        ArrayList<String> apanels = new ArrayList<String>();
        for (Panel panel : this.ctx.plugin.panelList) {
            apanels.add(panel.getName());
        }
        boolean foundItem = false;
        for (ItemStack temp : inv.getContents()) {
            if (temp == null) continue;
            foundItem = true;
            break;
        }
        if (!foundItem) {
            p.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Cancelled Panel!"));
            return;
        }
        String date = "panel-1";
        int count = 1;
        while (Arrays.asList(Objects.requireNonNull(this.ctx.configHandler.panelsFolder.list())).contains("panel-" + count + ".yml") || apanels.contains("panel-" + count)) {
            date = "panel-" + (count + 1);
            ++count;
        }
        File folder = new File(this.ctx.plugin.getDataFolder() + File.separator + "panels");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(folder + File.separator + date + ".yml"));
        yamlConfiguration.set("panels." + date + ".perm", (Object)"default");
        if (inv.getType().toString().contains("CHEST")) {
            yamlConfiguration.set("panels." + date + ".rows", (Object)(inv.getSize() / 9));
        } else {
            yamlConfiguration.set("panels." + date + ".rows", (Object)inv.getType().toString());
        }
        yamlConfiguration.set("panels." + date + ".title", (Object)("&8Generated " + date));
        yamlConfiguration.addDefault("panels." + date + ".command", (Object)date);
        if (this.ctx.version.isBelow("1.13")) {
            yamlConfiguration.set("panels." + date + ".empty", (Object)"STAINED_GLASS_PANE");
            yamlConfiguration.set("panels." + date + ".emptyID", (Object)"15");
        } else {
            yamlConfiguration.set("panels." + date + ".empty", (Object)"BLACK_STAINED_GLASS_PANE");
        }
        GenItemUtils items = new GenItemUtils(this.ctx);
        YamlConfiguration yamlConfiguration2 = items.generatePanelFile(date, inv, yamlConfiguration);
        try {
            yamlConfiguration2.save(new File(this.ctx.configHandler.panelsFolder + File.separator + date + ".yml"));
            p.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.GREEN + "Saved Generated File To: " + date + ".yml"));
        }
        catch (IOException var16) {
            p.sendMessage(this.ctx.text.colour(this.ctx.tag + ChatColor.RED + "Could Not Save Generated Panel!"));
        }
        this.ctx.reloader.reloadPanelFiles();
    }
}

