/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.generate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.libs.nbtapi.NBTItem;
import org.bukkit.Bukkit;
import org.bukkit.block.banner.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class GenItemUtils {
    Context ctx;

    public GenItemUtils(Context pl) {
        this.ctx = pl;
    }

    public YamlConfiguration generatePanelFile(String panelName, Inventory inv, YamlConfiguration file) {
        for (int i = 0; inv.getSize() > i; ++i) {
            ItemStack cont = inv.getItem(i);
            try {
                if (cont == null && file.contains("panels." + panelName + ".item." + i) && !file.getString("panels." + panelName + ".item." + i + ".material").equalsIgnoreCase("AIR")) {
                    file.set("panels." + panelName + ".item." + i, null);
                    continue;
                }
                if (this.ctx.version.isBelow("1.13") && cont.getDurability() != 0 && !cont.getType().toString().equals("SKULL_ITEM")) {
                    file.set("panels." + panelName + ".item." + i + ".ID", (Object)cont.getDurability());
                }
                if (file.contains("panels." + panelName + ".item." + i + ".material")) {
                    if (Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("%") || Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("=")) {
                        if (!cont.getType().toString().equalsIgnoreCase("PLAYER_HEAD") || cont.getType().toString().equalsIgnoreCase("SKULL_ITEM")) {
                            file.set("panels." + panelName + ".item." + i + ".material", (Object)cont.getType().toString());
                        }
                    } else {
                        file.set("panels." + panelName + ".item." + i + ".material", (Object)cont.getType().toString());
                    }
                } else {
                    file.set("panels." + panelName + ".item." + i + ".material", (Object)cont.getType().toString());
                }
                if ((cont.getType().toString().equalsIgnoreCase("PLAYER_HEAD") || cont.getType().toString().equalsIgnoreCase("SKULL_ITEM")) && !Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("%") && !Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("=")) {
                    file.set("panels." + panelName + ".item." + i + ".material", (Object)(this.ctx.version.isBelow("1.13") ? "SKULL_ITEM" : "PLAYER_HEAD"));
                }
                try {
                    BannerMeta bannerMeta = (BannerMeta)cont.getItemMeta();
                    ArrayList<String> dyePattern = new ArrayList<String>();
                    for (Pattern pattern : bannerMeta.getPatterns()) {
                        dyePattern.add(pattern.getColor() + "," + pattern.getPattern());
                    }
                    file.set("panels." + panelName + ".item." + i + ".banner", dyePattern);
                }
                catch (Exception ignore) {
                    file.set("panels." + panelName + ".item." + i + ".banner", null);
                }
                try {
                    if (this.ctx.version.isBelow("1.20.5")) {
                        if (this.ctx.potion_1_20_4.retrievePotionData(cont) != null) {
                            file.set("panels." + panelName + ".item." + i + ".potion", (Object)this.ctx.potion_1_20_4.retrievePotionData(cont));
                        }
                    } else {
                        PotionMeta potionMeta = (PotionMeta)cont.getItemMeta();
                        assert (potionMeta != null);
                        String potionType = potionMeta.getBasePotionType().toString();
                        file.set("panels." + panelName + ".item." + i + ".potion", (Object)potionType);
                    }
                }
                catch (Exception ignore) {
                    file.set("panels." + panelName + ".item." + i + ".potion", null);
                }
                file.set("panels." + panelName + ".item." + i + ".stack", (Object)cont.getAmount());
                if (!cont.getEnchantments().isEmpty()) {
                    Map enchantments = cont.getEnchantments();
                    ArrayList<String> newEnchantments = new ArrayList<String>();
                    for (Enchantment enchantment : enchantments.keySet()) {
                        newEnchantments.add(enchantment.getKey().getKey() + " " + enchantments.get(enchantment));
                    }
                    file.set("panels." + panelName + ".item." + i + ".enchanted", newEnchantments);
                }
                file.set("panels." + panelName + ".item." + i + ".name", (Object)Objects.requireNonNull(cont.getItemMeta()).getDisplayName());
                file.set("panels." + panelName + ".item." + i + ".lore", (Object)Objects.requireNonNull(cont.getItemMeta()).getLore());
                if (this.ctx.version.isAtLeast("1.14") && cont.getItemMeta().hasCustomModelData()) {
                    file.set("panels." + panelName + ".item." + i + ".customdata", (Object)Objects.requireNonNull(cont.getItemMeta()).getCustomModelData());
                }
                if (this.ctx.version.isAtLeast("1.21.4")) {
                    try {
                        Method getItemModelMethod = ItemMeta.class.getMethod("getItemModel", new Class[0]);
                        Object itemModelData = getItemModelMethod.invoke((Object)cont.getItemMeta(), new Object[0]);
                        file.set("panels." + panelName + ".item." + i + ".itemmodel", Objects.requireNonNull(itemModelData));
                    }
                    catch (NoSuchMethodException getItemModelMethod) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    NBTItem nbtItem = new NBTItem(cont);
                    String basePath = "panels." + panelName + ".item." + i + ".nbt";
                    for (String key : nbtItem.getKeys()) {
                        Object value = this.ctx.nbt.getNBTValue(nbtItem.getItem(), key);
                        if (value == null) continue;
                        if (value instanceof Map) {
                            ConfigurationSection subSection = file.createSection(basePath + "." + key);
                            this.ctx.nbt.saveMapToYAML((Map)value, subSection);
                            continue;
                        }
                        file.set(basePath + "." + key, value);
                    }
                    continue;
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("Error while saving NBT data: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }
}

