/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.placeholders.resolvers;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.formatter.placeholders.PlaceholderResolver;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.entity.Player;

public class ServerPlaceholder
implements PlaceholderResolver {
    private final Map<String, Boolean> cachedStatus = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> inProgress = new ConcurrentHashMap<String, Boolean>();

    @Override
    public boolean canResolve(String identifier) {
        return identifier.startsWith("server-");
    }

    @Override
    public String resolve(Panel panel, PanelPosition position, Player p, String identifier, Context ctx) {
        String ipPort = identifier.replace("server-", "");
        if (this.cachedStatus.containsKey(ipPort)) {
            return this.cachedStatus.get(ipPort) != false ? "true" : "false";
        }
        if (!this.inProgress.containsKey(ipPort)) {
            this.inProgress.put(ipPort, true);
            ctx.scheduler.runTaskAsynchronously(() -> {
                boolean result = this.pingServer(ipPort);
                this.cachedStatus.put(ipPort, result);
                this.inProgress.remove(ipPort);
            });
        }
        return "pinging";
    }

    private boolean pingServer(String ipPort) {
        boolean bl;
        int port;
        String[] parts = ipPort.split(":");
        if (parts.length != 2) {
            return false;
        }
        String ip = parts[0];
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(ip, port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        socket.close();
        return bl;
    }
}

