/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.placeholders.resolvers;

import com.earth2me.essentials.Essentials;
import java.util.ArrayList;
import java.util.Objects;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.formatter.placeholders.PlaceholderResolver;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerOnlinePlaceholder
implements PlaceholderResolver {
    @Override
    public boolean canResolve(String identifier) {
        return identifier.startsWith("player-online-");
    }

    @Override
    public String resolve(Panel panel, PanelPosition position, Player p, String identifier, Context ctx) {
        String playerLocation = identifier.replace("player-online-", "");
        if (identifier.endsWith("-visible")) {
            playerLocation = playerLocation.replace("-visible", "");
            ArrayList<Player> playerList = new ArrayList<Player>();
            for (Player temp : Bukkit.getOnlinePlayers()) {
                if (this.isPlayerVanished(temp)) continue;
                playerList.add(temp);
            }
            if (playerList.size() >= Integer.parseInt(playerLocation)) {
                return ((Player)playerList.get(Integer.parseInt(playerLocation) - 1)).getName();
            }
        } else if (Bukkit.getOnlinePlayers().toArray().length >= Integer.parseInt(playerLocation)) {
            return ((Player)Bukkit.getOnlinePlayers().toArray()[Integer.parseInt(playerLocation) - 1]).getName();
        }
        return ctx.text.colour(Objects.requireNonNull(ctx.configHandler.config.getString("config.format.offline")));
    }

    private boolean isPlayerVanished(Player player) {
        if (!Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
            return false;
        }
        Essentials essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        return essentials.getUser(player).isVanished();
    }
}

