/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.formatter.placeholders;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.rockyhawk.commandpanels.Context;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.formatter.placeholders.PlaceholderResolver;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.CheckInventoryPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.CustomPlaceholders;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.DamagedPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.DataPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.Identical;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.LorePlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.MaterialPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.MathDataPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.ModelDataPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.NBTPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.NamePlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.PlayerOnlinePlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.PlayerPlaceholders;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.PotionPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.RandomPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.ServerPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.SetDataPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.StackPlaceholder;
import me.rockyhawk.commandpanels.formatter.placeholders.resolvers.UUIDPlaceholder;
import me.rockyhawk.commandpanels.manager.session.PanelPosition;
import org.bukkit.entity.Player;

public class Placeholders {
    private final Context ctx;
    private final List<PlaceholderResolver> resolvers = new ArrayList<PlaceholderResolver>();

    public Placeholders(Context ctx) {
        this.ctx = ctx;
        this.loadPlaceholders();
    }

    public void addPlaceholder(PlaceholderResolver placeholder) {
        this.resolvers.add(placeholder);
    }

    private void loadPlaceholders() {
        this.resolvers.add(new CheckInventoryPlaceholder());
        this.resolvers.add(new DamagedPlaceholder());
        this.resolvers.add(new DataPlaceholder());
        this.resolvers.add(new Identical());
        this.resolvers.add(new LorePlaceholder());
        this.resolvers.add(new MaterialPlaceholder());
        this.resolvers.add(new MathDataPlaceholder());
        this.resolvers.add(new ModelDataPlaceholder());
        this.resolvers.add(new NamePlaceholder());
        this.resolvers.add(new NBTPlaceholder());
        this.resolvers.add(new CustomPlaceholders());
        this.resolvers.add(new PlayerPlaceholders());
        this.resolvers.add(new PlayerOnlinePlaceholder());
        this.resolvers.add(new PotionPlaceholder());
        this.resolvers.add(new RandomPlaceholder());
        this.resolvers.add(new ServerPlaceholder());
        this.resolvers.add(new SetDataPlaceholder());
        this.resolvers.add(new StackPlaceholder());
        this.resolvers.add(new UUIDPlaceholder());
    }

    public String setPlaceholders(Panel panel, PanelPosition position, Player p, String str, boolean primary) {
        String previous;
        StringBuffer sb;
        String[] HOLDERS = this.getPlaceholderEnds(panel, primary);
        if (HOLDERS[0] == null || HOLDERS[1] == null) {
            return str;
        }
        String start = Pattern.quote(HOLDERS[0]);
        String end = Pattern.quote(HOLDERS[1]);
        Pattern pattern = Pattern.compile(start + "cp-([a-zA-Z0-9_\\-]+)" + end);
        int maxPasses = 255;
        int count = 0;
        do {
            previous = str;
            sb = new StringBuffer();
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                String identifier = matcher.group(1);
                String replacement = this.resolvePlaceholder(panel, position, p, identifier);
                if (replacement == null) {
                    replacement = "";
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(sb);
        } while (!(str = sb.toString()).equals(previous) && ++count < maxPasses);
        return str;
    }

    protected String resolvePlaceholder(Panel panel, PanelPosition position, Player p, String identifier) {
        for (PlaceholderResolver resolver : this.resolvers) {
            if (!resolver.canResolve(identifier)) continue;
            try {
                identifier = resolver.resolve(panel, position, p, identifier, this.ctx);
            }
            catch (Exception ex) {
                this.ctx.debug.send(ex, p, this.ctx);
            }
        }
        return identifier;
    }

    public String[] getPlaceholderEnds(Panel panel, boolean primary) {
        String[] primaryEnds = new String[]{this.ctx.configHandler.config.getString("placeholders.primary.start"), this.ctx.configHandler.config.getString("placeholders.primary.end")};
        String[] secondaryEnds = new String[]{this.ctx.configHandler.config.getString("placeholders.secondary.start"), this.ctx.configHandler.config.getString("placeholders.secondary.end")};
        if (panel != null && panel.getConfig().isSet("placeholders")) {
            if (panel.getConfig().isSet("placeholders.primary")) {
                primaryEnds = new String[]{panel.getConfig().getString("placeholders.primary.start"), panel.getConfig().getString("placeholders.primary.end")};
            }
            if (panel.getConfig().isSet("placeholders.secondary")) {
                secondaryEnds = new String[]{panel.getConfig().getString("placeholders.secondary.start"), panel.getConfig().getString("placeholders.secondary.end")};
            }
        }
        return primary ? primaryEnds : secondaryEnds;
    }
}

